/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.XADataSource;
import org.jboss.jdbc.XADataSourceLoaderMBean;
import org.jboss.logging.Logger;
import org.jboss.logging.log4j.CategoryWriter;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.pool.jdbc.xa.XAPoolDataSource;
import org.jboss.util.ServiceMBeanSupport;

public class XADataSourceLoader
extends ServiceMBeanSupport
implements XADataSourceLoaderMBean {
    String name;
    String dataSourceClass;
    String url;
    String userName;
    String password;
    String properties;
    boolean loggingEnabled;
    int minSize;
    int maxSize;
    boolean blocking;
    boolean gcEnabled;
    long gcInterval;
    long gcMinIdleTime;
    boolean idleTimeoutEnabled;
    long idleTimeout;
    float maxIdleTimeoutPercent;
    boolean invalidateOnError;
    boolean timestampUsed;
    int blockingTimeout;
    int transactionIsolation = -1;
    int psCacheSize = 10;
    boolean releaseOnCommit = false;
    boolean saveStackTrace = false;
    XAPoolDataSource source;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public XADataSourceLoader() {
    }

    public XADataSourceLoader(String poolName, String xaDataSourceClass) {
        this.setPoolName(poolName);
        this.setDataSourceClass(xaDataSourceClass);
    }

    private void bind(Context ctx, String name, Object val) throws NamingException {
        NonSerializableFactory.bind(name, val);
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", name);
        Reference ref = new Reference(val.getClass().getName(), addr, (class$org$jboss$naming$NonSerializableFactory != null ? class$org$jboss$naming$NonSerializableFactory : (class$org$jboss$naming$NonSerializableFactory = XADataSourceLoader.class$("org.jboss.naming.NonSerializableFactory"))).getName(), null);
        ctx.bind(n.get(0), (Object)ref);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void cleanupSource() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
    }

    public long getAvailableConnections() {
        return this.getSource().getAvailableConnections();
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public int getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public String getDataSourceClass() {
        return this.dataSourceClass;
    }

    public boolean getGCEnabled() {
        return this.gcEnabled;
    }

    public long getGCInterval() {
        return this.gcInterval;
    }

    public long getGCMinIdleTime() {
        return this.gcMinIdleTime;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean getIdleTimeoutEnabled() {
        return this.idleTimeoutEnabled;
    }

    public boolean getInvalidateOnError() {
        return this.invalidateOnError;
    }

    public String getJDBCUser() {
        return this.userName;
    }

    public boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public float getMaxIdleTimeoutPercent() {
        return this.maxIdleTimeoutPercent;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public String getName() {
        return this.name;
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName objectName) throws MalformedObjectNameException {
        return objectName == null ? new ObjectName(":service=XADataSource,name=" + this.getSource().getPoolName()) : objectName;
    }

    public int getPSCacheSize() {
        return this.psCacheSize;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPoolName() {
        return this.name;
    }

    public String getProperties() {
        return this.properties;
    }

    public boolean getReleaseOnCommit() {
        return this.releaseOnCommit;
    }

    public boolean getSaveStackTrace() {
        return this.saveStackTrace;
    }

    private XAPoolDataSource getSource() {
        if (this.source == null) {
            this.source = new XAPoolDataSource();
        }
        return this.source;
    }

    public boolean getTimestampUsed() {
        return this.timestampUsed;
    }

    public String getTransactionIsolation() {
        switch (this.transactionIsolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "DEFAULT";
    }

    public String getURL() {
        return this.url;
    }

    public long getUsedConnections() {
        return this.getSource().getUsedConnections();
    }

    private static Properties parseProperties(String string) {
        Properties props = new Properties();
        StringTokenizer tokens = new StringTokenizer(string, ";=");
        while (tokens.hasMoreTokens()) {
            String key = tokens.nextToken();
            String value = tokens.nextToken();
            ((Hashtable)props).put(key, value);
        }
        return props;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    public void setDataSourceClass(String clazz) {
        this.dataSourceClass = clazz;
    }

    public void setGCEnabled(boolean gcEnabled) {
        this.gcEnabled = gcEnabled;
    }

    public void setGCInterval(long interval) {
        this.gcInterval = interval;
    }

    public void setGCMinIdleTime(long idleMillis) {
        this.gcMinIdleTime = idleMillis;
    }

    public void setIdleTimeout(long idleMillis) {
        this.idleTimeout = idleMillis;
    }

    public void setIdleTimeoutEnabled(boolean enabled) {
        this.idleTimeoutEnabled = enabled;
    }

    public void setInvalidateOnError(boolean invalidate) {
        this.invalidateOnError = invalidate;
    }

    public void setJDBCUser(String userName) {
        this.userName = userName;
    }

    public void setLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        this.maxIdleTimeoutPercent = percent;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public void setPSCacheSize(int size) {
        this.psCacheSize = size;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPoolName(String name) {
        this.name = name;
        String logName = String.valueOf(this.getClass().getName()) + '.' + name;
        this.log = Logger.getLogger(logName);
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setReleaseOnCommit(boolean rel) {
        this.releaseOnCommit = rel;
    }

    public void setSaveStackTrace(boolean save) {
        this.saveStackTrace = save;
    }

    public void setTimestampUsed(boolean timestamp) {
        this.timestampUsed = timestamp;
    }

    public void setTransactionIsolation(String iso) {
        if (iso.equals("TRANSACTION_NONE")) {
            this.transactionIsolation = 0;
        } else if (iso.equals("TRANSACTION_READ_COMMITTED")) {
            this.transactionIsolation = 2;
        } else if (iso.equals("TRANSACTION_READ_UNCOMMITTED")) {
            this.transactionIsolation = 1;
        } else if (iso.equals("TRANSACTION_REPEATABLE_READ")) {
            this.transactionIsolation = 4;
        } else if (iso.equals("TRANSACTION_SERIALIZABLE")) {
            this.transactionIsolation = 8;
        } else {
            throw new IllegalArgumentException("Setting Isolation level to unknown state: " + iso);
        }
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void startService() throws Exception {
        this.getSource().setPoolName(this.name);
        XADataSource vendorSource = null;
        Class<?> cls = Class.forName(this.dataSourceClass);
        vendorSource = (XADataSource)cls.newInstance();
        this.getSource().setDataSource(vendorSource);
        cls = vendorSource.getClass();
        if (this.url != null && this.url.length() > 0) {
            Method setURL = cls.getMethod("setURL", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = XADataSourceLoader.class$("java.lang.String")));
            setURL.invoke((Object)vendorSource, this.url);
        }
        cls = vendorSource.getClass();
        if (this.properties != null && this.properties.length() > 0) {
            Properties props = XADataSourceLoader.parseProperties(this.properties);
            Method setProperties = cls.getMethod("setProperties", class$java$util$Properties != null ? class$java$util$Properties : (class$java$util$Properties = XADataSourceLoader.class$("java.util.Properties")));
            setProperties.invoke((Object)vendorSource, props);
        }
        if (this.userName != null && this.userName.length() > 0) {
            this.getSource().setJDBCUser(this.userName);
        }
        if (this.password != null && this.password.length() > 0) {
            this.getSource().setJDBCPassword(this.password);
        }
        CategoryWriter writer = this.loggingEnabled ? new CategoryWriter(this.log.getCategory()) : null;
        this.getSource().setLogWriter((PrintWriter)writer);
        this.getSource().getDataSource().setLogWriter(writer);
        this.getSource().setMinSize(this.minSize);
        this.getSource().setMaxSize(this.maxSize);
        this.getSource().setBlocking(this.blocking);
        this.getSource().setBlockingTimeout(this.blockingTimeout);
        this.getSource().setGCEnabled(this.gcEnabled);
        this.getSource().setGCInterval(this.gcInterval);
        this.getSource().setGCMinIdleTime(this.gcMinIdleTime);
        this.getSource().setIdleTimeoutEnabled(this.idleTimeoutEnabled);
        this.getSource().setIdleTimeout(this.idleTimeout);
        this.getSource().setMaxIdleTimeoutPercent(this.maxIdleTimeoutPercent);
        this.getSource().setInvalidateOnError(this.invalidateOnError);
        this.getSource().setTimestampUsed(this.timestampUsed);
        this.getSource().setTransactionIsolation(this.transactionIsolation);
        this.getSource().setPSCacheSize(this.psCacheSize);
        this.getSource().setReleaseOnCommit(this.releaseOnCommit);
        this.getSource().setSaveStackTrace(this.saveStackTrace);
        InitialContext ctx = null;
        Object mgr = null;
        this.getSource().setTransactionManagerJNDIName("java:/TransactionManager");
        try {
            ctx = new InitialContext();
            mgr = ctx.lookup("java:/TransactionManager");
        }
        catch (NamingException namingException) {
            throw new IllegalStateException("Cannot start XA Connection Pool; there is no TransactionManager in JNDI!");
        }
        this.getSource().initialize();
        this.bind(new InitialContext(), "java:/" + this.getSource().getPoolName(), this.source);
        this.log.info("XA Connection pool " + this.getSource().getPoolName() + " bound to java:/" + this.getSource().getPoolName());
        try {
            this.getSource().getConnection().close();
        }
        catch (Exception e) {
            this.cleanupSource();
            throw e;
        }
    }

    public void stopService() {
        try {
            String name = this.getSource().getPoolName();
            new InitialContext().unbind("java:/" + name);
            this.log.info("XA Connection pool " + name + " removed from JNDI");
            this.cleanupSource();
            this.log.info("XA Connection pool " + name + " shut down");
        }
        catch (NamingException namingException) {}
    }
}

