/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms;

import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import org.apache.log4j.Category;

public class ConnectionFactoryHelper {
    private static Category log = Category.getInstance((Class)(class$org$jboss$jms$ConnectionFactoryHelper != null ? class$org$jboss$jms$ConnectionFactoryHelper : (class$org$jboss$jms$ConnectionFactoryHelper = ConnectionFactoryHelper.class$("org.jboss.jms.ConnectionFactoryHelper"))));
    static /* synthetic */ Class class$org$jboss$jms$ConnectionFactoryHelper;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static QueueConnection createQueueConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createQueueConnection(factory, null, null);
    }

    public static QueueConnection createQueueConnection(Object factory, String username, String password) throws JMSException {
        XAQueueConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("using connection factory: " + factory));
            log.debug((Object)("using username/password: " + String.valueOf(username) + "/" + String.valueOf(password)));
        }
        if (factory instanceof XAQueueConnectionFactory) {
            XAQueueConnectionFactory qFactory = (XAQueueConnectionFactory)factory;
            connection = username != null ? qFactory.createXAQueueConnection(username, password) : qFactory.createXAQueueConnection();
            log.debug((Object)("created XAQueueConnection: " + connection));
        } else if (factory instanceof QueueConnectionFactory) {
            QueueConnectionFactory qFactory = (QueueConnectionFactory)factory;
            connection = username != null ? qFactory.createQueueConnection(username, password) : qFactory.createQueueConnection();
            log.debug((Object)("created QueueConnection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static TopicConnection createTopicConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createTopicConnection(factory, null, null);
    }

    public static TopicConnection createTopicConnection(Object factory, String username, String password) throws JMSException {
        XATopicConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("using connection factory: " + factory));
            log.debug((Object)("using username/password: " + String.valueOf(username) + "/" + String.valueOf(password)));
        }
        if (factory instanceof XATopicConnectionFactory) {
            XATopicConnectionFactory tFactory = (XATopicConnectionFactory)factory;
            connection = username != null ? tFactory.createXATopicConnection(username, password) : tFactory.createXATopicConnection();
            log.debug((Object)("created XATopicConnection: " + connection));
        } else if (factory instanceof TopicConnectionFactory) {
            TopicConnectionFactory tFactory = (TopicConnectionFactory)factory;
            connection = username != null ? tFactory.createTopicConnection(username, password) : tFactory.createTopicConnection();
            log.debug((Object)("created TopicConnection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }
}

