/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.jboss.jms.asf.StdServerSession;
import org.jboss.logging.Logger;

public class StdServerSessionPool
implements ServerSessionPool {
    private static final int DEFAULT_POOL_SIZE = 15;
    private static ThreadGroup threadGroup = new ThreadGroup("ASF Session Pool Threads");
    private final Logger log = Logger.getLogger(this.getClass());
    private int poolSize;
    private int ack;
    private boolean useLocalTX;
    private boolean transacted;
    private Connection con;
    private MessageListener listener;
    private List sessionPool;
    private PooledExecutor executor;
    private boolean closing = false;
    private int numServerSessions = 0;

    public StdServerSessionPool(Connection con, boolean transacted, int ack, boolean useLocalTX, MessageListener listener, int maxSession) throws JMSException {
        this.con = con;
        this.ack = ack;
        this.listener = listener;
        this.transacted = transacted;
        this.poolSize = maxSession;
        this.sessionPool = new ArrayList(maxSession);
        this.useLocalTX = useLocalTX;
        this.executor = new PooledExecutor(this.poolSize);
        this.executor.setMinimumPoolSize(0);
        this.executor.setKeepAliveTime(30000L);
        this.executor.waitWhenBlocked();
        this.executor.setThreadFactory(new ThreadFactory(){
            private volatile int count = 0;

            public Thread newThread(Runnable command) {
                return new Thread(threadGroup, command, "Thread Pool Worker-" + this.count++);
            }
        });
        this.init();
        this.log.debug("Server Session pool set up");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        List list = this.sessionPool;
        synchronized (list) {
            this.closing = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Clearing " + this.sessionPool.size() + " from ServerSessionPool");
            }
            Iterator iter = this.sessionPool.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    this.sessionPool.clear();
                    this.sessionPool.notifyAll();
                    break;
                }
                StdServerSession ses = (StdServerSession)iter.next();
                ses.close();
                --this.numServerSessions;
            }
        }
        this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        list = this.sessionPool;
        synchronized (list) {
            while (true) {
                if (this.numServerSessions <= 0) {
                    return;
                }
                try {
                    this.sessionPool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    Executor getExecutor() {
        return this.executor;
    }

    /*
     * Unable to fully structure code
     */
    public ServerSession getServerSession() throws JMSException {
        block12: {
            if (this.log.isTraceEnabled()) {
                this.log.trace("getting a server session");
            }
            session = null;
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    var2_2 = this.sessionPool;
                    synchronized (var2_2) {
                        if (this.closing) {
                            throw new JMSException("Cannot get session after pool has been closed down.");
                        }
                        if (this.sessionPool.size() > 0) {
                            session = (ServerSession)this.sessionPool.remove(0);
                            var3_4 = null;
                            break block12;
                        }
                        try {
                            this.sessionPool.wait();
                        }
                        catch (InterruptedException v0) {}
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new JMSException("Failed to get a server session: " + e);
            }
            {
                ** while (true)
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("using server session: " + session);
        }
        return session;
    }

    private void init() throws JMSException {
        int index = 0;
        while (index < this.poolSize) {
            TopicSession ses = null;
            XATopicSession xaSes = null;
            this.log.debug("initializing with connection: " + this.con);
            if (this.con instanceof XATopicConnection) {
                xaSes = ((XATopicConnection)this.con).createXATopicSession();
                ses = xaSes.getTopicSession();
            } else if (this.con instanceof XAQueueConnection) {
                xaSes = ((XAQueueConnection)this.con).createXAQueueSession();
                ses = ((XAQueueSession)xaSes).getQueueSession();
            } else if (this.con instanceof TopicConnection) {
                ses = ((TopicConnection)this.con).createTopicSession(this.transacted, this.ack);
                this.log.warn("Using a non-XA TopicConnection.  It will not be able to participate in a Global UOW");
            } else if (this.con instanceof QueueConnection) {
                ses = ((QueueConnection)this.con).createQueueSession(this.transacted, this.ack);
                this.log.warn("Using a non-XA QueueConnection.  It will not be able to participate in a Global UOW");
            } else {
                this.log.error("Connection was not reconizable: " + this.con);
                throw new JMSException("Connection was not reconizable: " + this.con);
            }
            StdServerSession serverSession = new StdServerSession(this, (Session)ses, (XASession)xaSes, this.listener, this.useLocalTX);
            this.sessionPool.add(serverSession);
            ++this.numServerSessions;
            this.log.debug("added server session to the pool: " + serverSession);
            ++index;
        }
    }

    boolean isTransacted() {
        return this.transacted;
    }

    void recycle(StdServerSession session) {
        List list = this.sessionPool;
        synchronized (list) {
            if (this.closing) {
                session.close();
                --this.numServerSessions;
                if (this.numServerSessions == 0) {
                    this.sessionPool.notifyAll();
                }
            } else {
                this.sessionPool.add(session);
                this.sessionPool.notifyAll();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("recycled server session: " + session);
                }
            }
        }
    }
}

