/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.jndi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Category;
import org.jboss.jms.jndi.AbstractJMSProviderAdapter;

public class JBossMQProvider
extends AbstractJMSProviderAdapter {
    public static final String INITIAL_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    public static final String URL_PKG_PREFIXES = "org.jboss.naming";
    private static final String SECURITY_MANAGER = "java.naming.rmi.security.manager";
    private transient Category log = Category.getInstance(this.getClass());
    private String hasJndiSecurityManager = "yes";

    public JBossMQProvider() {
        this.log.debug((Object)"initializing");
    }

    public Context getInitialContext() throws NamingException {
        InitialContext ctx = null;
        if (this.providerURL == null) {
            this.log.debug((Object)"no provider url; connecting to local JNDI");
            ctx = new InitialContext();
        } else {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
            props.put("java.naming.provider.url", this.providerURL);
            props.put(SECURITY_MANAGER, this.hasJndiSecurityManager);
            props.put("java.naming.factory.url.pkgs", URL_PKG_PREFIXES);
            this.log.debug((Object)("connecting to remote JNDI with props: " + props));
            ctx = new InitialContext(props);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("created context: " + ctx));
        }
        return ctx;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.log = Category.getInstance(this.getClass());
    }
}

