/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.ra;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.jms.ra.JmsConnectionManager;
import org.jboss.jms.ra.JmsSessionFactoryImpl;
import org.jboss.jms.ra.client.JmsConnectionFactory;

public class JmsConnectionFactoryImpl
implements JmsConnectionFactory,
Serializable,
Referenceable {
    private Reference reference;
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;

    public JmsConnectionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
        this.cm = cm == null ? new JmsConnectionManager() : cm;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm);
        s.isTopic(Boolean.FALSE);
        return s;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm);
        s.isTopic(Boolean.FALSE);
        s.setUserName(userName);
        s.setPassword(password);
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm);
        s.isTopic(Boolean.TRUE);
        return s;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm);
        s.isTopic(Boolean.TRUE);
        s.setUserName(userName);
        s.setPassword(password);
        return s;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }
}

