/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.ra;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.jms.ConnectionFactoryHelper;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.jms.ra.JmsConnectionRequestInfo;
import org.jboss.jms.ra.JmsCred;
import org.jboss.jms.ra.JmsLocalTransaction;
import org.jboss.jms.ra.JmsLogger;
import org.jboss.jms.ra.JmsManagedConnectionFactory;
import org.jboss.jms.ra.JmsMetaData;
import org.jboss.jms.ra.JmsSession;
import org.jboss.jms.ra.Level;

public class JmsManagedConnection
implements ManagedConnection {
    private JmsManagedConnectionFactory mcf;
    private JmsConnectionRequestInfo info;
    private String user;
    private String pwd;
    private boolean isDestroyed;
    private Connection con;
    private TopicSession topicSession;
    private XATopicSession xaTopicSession;
    private QueueSession queueSession;
    private XAQueueSession xaQueueSession;
    private XAResource xaResource;
    private boolean xaTransacted;
    private PrintWriter logWriter;
    private JmsLogger logger = new JmsLogger();
    private Set handles = new HashSet();
    private Vector listeners = new Vector();

    public JmsManagedConnection(JmsManagedConnectionFactory mcf, ConnectionRequestInfo info, String user, String pwd) throws ResourceException {
        this.mcf = mcf;
        this.info = (JmsConnectionRequestInfo)info;
        this.user = user;
        this.pwd = pwd;
        this.setup();
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        this.logger.log(Level.FINE, "ConnectionEvent listener added");
        this.listeners.addElement(l);
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (this.isDestroyed || !(obj instanceof JmsSession)) {
            throw new IllegalStateException("ManagedConnection in an illegal state");
        }
        JmsSession h = (JmsSession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        this.destroyHandles();
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.destroyHandles();
        try {
            if (this.info.isTopic()) {
                this.topicSession.close();
                if (this.xaTransacted) {
                    this.xaTopicSession.close();
                }
            } else {
                this.queueSession.close();
                if (this.xaTransacted) {
                    this.xaQueueSession.close();
                }
            }
            this.con.close();
        }
        catch (JMSException ex) {
            ResourceException e = new ResourceException("Could not properly close the session and connection: " + (Object)((Object)ex));
            e.setLinkedException((Exception)((Object)ex));
            throw e;
        }
    }

    private void destroyHandles() throws ResourceException {
        Iterator iter = this.handles.iterator();
        while (iter.hasNext()) {
            ((JmsSession)iter.next()).destroy();
        }
        this.handles.clear();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JmsCred cred = JmsCred.getJmsCred(this.mcf, subject, info);
        if (this.user != null && !this.user.equals(cred.name)) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (cred.name != null && this.user == null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        this.user = cred.name;
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        JmsSession handle = new JmsSession(this);
        this.handles.add(handle);
        return handle;
    }

    protected ConnectionRequestInfo getInfo() {
        return this.info;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        this.logger.log(Level.FINE, "Leaving out LocalTransaction");
        return new JmsLocalTransaction(this);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    protected JmsLogger getLogger() {
        return this.logger;
    }

    protected JmsManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        return new JmsMetaData(this);
    }

    private JMSProviderAdapter getProviderAdapter() throws NamingException {
        JMSProviderAdapter adapter;
        if (this.mcf.getJmsProviderAdapterJNDI() != null) {
            InitialContext ctx = new InitialContext();
            try {
                adapter = (JMSProviderAdapter)ctx.lookup(this.mcf.getJmsProviderAdapterJNDI());
            }
            finally {
                Object var4_3 = null;
                ctx.close();
            }
        } else {
            adapter = this.mcf.getJmsProviderAdapter();
        }
        return adapter;
    }

    protected Session getSession() {
        if (this.info.isTopic()) {
            return this.topicSession;
        }
        return this.queueSession;
    }

    protected String getUserName() {
        return this.user;
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.xaTransacted) {
            throw new NotSupportedException("XA transaction not supported");
        }
        if (this.xaResource == null) {
            this.xaResource = this.info.isTopic() ? this.xaTopicSession.getXAResource() : this.xaQueueSession.getXAResource();
        }
        this.logger.log(Level.FINE, "Leaving out XAResource");
        return this.xaResource;
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }

    protected void removeHandle(JmsSession handle) {
        this.handles.remove(handle);
    }

    protected void sendEvent(ConnectionEvent event) {
        this.logger.log(Level.FINE, "Sending connection event: " + event.getId());
        Vector list = (Vector)this.listeners.clone();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ConnectionEventListener listener = (ConnectionEventListener)list.elementAt(i);
            int type = event.getId();
            switch (type) {
                case 1: {
                    listener.connectionClosed(event);
                    break;
                }
                case 2: {
                    listener.localTransactionStarted(event);
                    break;
                }
                case 3: {
                    listener.localTransactionCommitted(event);
                    break;
                }
                case 4: {
                    listener.localTransactionRolledback(event);
                    break;
                }
                case 5: {
                    listener.connectionErrorOccurred(event);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
            ++i;
        }
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
        if (out != null) {
            this.logger.setLogWriter(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setup() throws ResourceException {
        try {
            JMSProviderAdapter adapter = this.getProviderAdapter();
            Context context = adapter.getInitialContext();
            boolean transacted = true;
            int ack = 1;
            if (this.info.isTopic()) {
                Object factory = context.lookup(adapter.getTopicFactoryRef());
                this.con = ConnectionFactoryHelper.createTopicConnection(factory, this.user, this.pwd);
                this.logger.log(Level.FINE, "created connection: " + this.con);
                if (this.con instanceof XATopicConnection) {
                    this.xaTopicSession = ((XATopicConnection)this.con).createXATopicSession();
                    this.topicSession = this.xaTopicSession.getTopicSession();
                    this.xaTransacted = true;
                } else if (this.con instanceof TopicConnection) {
                    this.topicSession = ((TopicConnection)this.con).createTopicSession(transacted, ack);
                    this.logger.log(Level.WARNING, "Using a non-XA TopicConnection.  It will not be able to participate in a Global UOW");
                } else {
                    this.logger.log(Level.SEVERE, "Error in getting session for con: " + this.con);
                    throw new ResourceException("Connection was not reconizable: " + this.con);
                }
                this.logger.log(Level.FINE, "xaTopicSession: " + this.xaTopicSession);
                this.logger.log(Level.FINE, "topicSession: " + this.topicSession);
            } else {
                Object factory = context.lookup(adapter.getQueueFactoryRef());
                this.con = ConnectionFactoryHelper.createQueueConnection(factory, this.user, this.pwd);
                this.logger.log(Level.FINE, "created connection: " + this.con);
                if (this.con instanceof XAQueueConnection) {
                    this.xaQueueSession = ((XAQueueConnection)this.con).createXAQueueSession();
                    this.queueSession = this.xaQueueSession.getQueueSession();
                    this.xaTransacted = true;
                } else if (this.con instanceof QueueConnection) {
                    this.queueSession = ((QueueConnection)this.con).createQueueSession(transacted, ack);
                    this.logger.log(Level.WARNING, "Using a non-XA QueueConnection.  It will not be able to participate in a Global UOW");
                } else {
                    this.logger.log(Level.SEVERE, "Error in getting session for con: " + this.con);
                    throw new ResourceException("Connection was not reconizable: " + this.con);
                }
                this.con.start();
                this.logger.log(Level.FINE, "xaQueueSession: " + this.xaQueueSession);
                this.logger.log(Level.FINE, "queueSession: " + this.queueSession);
            }
            this.logger.log(Level.FINE, "transacted: " + transacted);
            this.logger.log(Level.FINE, "ack mode: " + ack);
        }
        catch (NamingException e) {
            CommException ce = new CommException(e.toString());
            ce.setLinkedException((Exception)e);
            throw ce;
        }
        catch (JMSException e) {
            void context;
            CommException ce = new CommException(e.toString());
            ce.setLinkedException((Exception)((Object)e));
            throw context;
        }
    }
}

