/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.ra;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.jms.ra.JmsConnectionFactoryImpl;
import org.jboss.jms.ra.JmsCred;
import org.jboss.jms.ra.JmsLogger;
import org.jboss.jms.ra.JmsManagedConnection;

public class JmsManagedConnectionFactory
implements ManagedConnectionFactory {
    private PrintWriter logWriter = null;
    private String providerJNDI;
    private JmsLogger logger = new JmsLogger();
    private JMSProviderAdapter adapter;

    public Object createConnectionFactory() throws ResourceException {
        return new JmsConnectionFactoryImpl(this, null);
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new JmsConnectionFactoryImpl(this, cxManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JmsCred cred = JmsCred.getJmsCred(this, subject, info);
        JmsManagedConnection mc = new JmsManagedConnection(this, info, cred.name, cred.pwd);
        mc.setLogWriter(this.logWriter);
        return mc;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmsManagedConnectionFactory) {
            String you = ((JmsManagedConnectionFactory)obj).getJmsProviderAdapterJNDI();
            String me = this.providerJNDI;
            return you == null ? me == null : you.equals(me);
        }
        return false;
    }

    public JMSProviderAdapter getJmsProviderAdapter() {
        return this.adapter;
    }

    public String getJmsProviderAdapterJNDI() {
        return this.providerJNDI;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public int hashCode() {
        if (this.providerJNDI == null) {
            return new String("").hashCode();
        }
        return this.providerJNDI.hashCode();
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JmsCred cred = JmsCred.getJmsCred(this, subject, info);
        Iterator connections = connectionSet.iterator();
        while (connections.hasNext()) {
            Object obj = connections.next();
            if (!(obj instanceof JmsManagedConnection)) continue;
            JmsManagedConnection mc = (JmsManagedConnection)obj;
            JmsManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.getUserName() != null && (mc.getUserName() == null || !mc.getUserName().equals(cred.name)) || !mcf.equals(this) || !info.equals((Object)mc.getInfo())) continue;
            return mc;
        }
        return null;
    }

    public void setJmsProviderAdapter(JMSProviderAdapter adapter) {
        this.adapter = adapter;
    }

    public void setJmsProviderAdapterJNDI(String jndi) {
        this.providerJNDI = jndi;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
        this.logger.setLogWriter(out);
    }
}

