/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URL;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.logging.Log4jServiceMBean;
import org.jboss.logging.log4j.CategoryStream;

public class Log4jService
implements Log4jServiceMBean,
MBeanRegistration {
    private Category category;
    private String configurationPath;
    private int refreshPeriod;
    private boolean refreshFlag;
    private PrintStream out;
    private PrintStream err;

    public Log4jService() {
        this("log4j.properties", 60);
    }

    public Log4jService(String path) {
        this(path, 60);
    }

    public Log4jService(String path, int refreshPeriod) {
        this.configurationPath = path;
        this.refreshPeriod = refreshPeriod;
        this.refreshFlag = true;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public boolean getRefreshFlag() {
        return this.refreshFlag;
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean b) {
    }

    public void preDeregister() {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.start();
        ObjectName logger = new ObjectName(server.getDefaultDomain(), "service", "Log");
        return name == null ? new ObjectName(":service=Logging,type=Log4J") : name;
    }

    public void setConfigurationPath(String path) {
        this.configurationPath = path;
    }

    public void setRefreshFlag(boolean flag) {
        this.refreshFlag = flag;
    }

    public void start() throws Exception {
        boolean isXML = this.configurationPath.endsWith(".xml");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(this.configurationPath);
        if (url == null) {
            throw new FileNotFoundException("Failed to find logj4 props: " + this.configurationPath);
        }
        if (this.refreshFlag) {
            String path = url.getFile();
            if (isXML) {
                DOMConfigurator.configureAndWatch((String)path, (long)(1000 * this.refreshPeriod));
            } else {
                PropertyConfigurator.configureAndWatch((String)path, (long)(1000 * this.refreshPeriod));
            }
        } else if (isXML) {
            DOMConfigurator.configure((URL)url);
        } else {
            PropertyConfigurator.configure((URL)url);
        }
        this.category = Category.getRoot();
        Category stdout = Category.getInstance((String)"STDOUT");
        this.out = System.out;
        System.setOut(new CategoryStream(stdout, Priority.INFO, this.out));
        this.category.info((Object)"Installed System.out adapter");
        Category stderr = Category.getInstance((String)"STDERR");
        this.err = System.err;
        System.setErr(new CategoryStream(stderr, Priority.INFO, this.err));
        this.category.info((Object)"Installed System.err adapter");
        this.category.info((Object)("Started Log4jService, config=" + url));
    }

    public void stop() {
        if (this.out != null) {
            System.out.flush();
            System.setOut(this.out);
            this.out = null;
        }
        if (this.err != null) {
            System.err.flush();
            System.setErr(this.err);
            this.err = null;
        }
        Category.shutdown();
        if (this.category != null) {
            this.category.info((Object)"Stopped Log4jService");
        }
    }
}

