/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mail;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.mail.MailServiceMBean;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.util.ServiceMBeanSupport;

public class MailService
extends ServiceMBeanSupport
implements MailServiceMBean {
    private String m_user;
    private String m_password;
    private String m_properties;
    private String m_jndiName;
    private String m_bindName;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    private void bind(Session session) throws NamingException {
        Context ctx = new InitialContext();
        String name = this.getJNDIName();
        if (name == null) {
            name = "java:/Mail";
        } else if (!name.startsWith("java:/")) {
            name = "java:/" + name;
        }
        this.m_bindName = name;
        NonSerializableFactory.bind(this.m_bindName, session);
        Name n = ctx.getNameParser("").parse(this.m_bindName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", this.m_bindName);
        Reference ref = new Reference((class$javax$mail$Session != null ? class$javax$mail$Session : (class$javax$mail$Session = MailService.class$("javax.mail.Session"))).getName(), addr, (class$org$jboss$naming$NonSerializableFactory != null ? class$org$jboss$naming$NonSerializableFactory : (class$org$jboss$naming$NonSerializableFactory = MailService.class$("org.jboss.naming.NonSerializableFactory"))).getName(), null);
        ctx.bind(n.get(0), (Object)ref);
        this.log.info("Mail Service '" + this.getJNDIName() + "' bound to " + this.m_bindName);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected String getConfigurationFile() {
        return this.m_properties;
    }

    protected String getJNDIName() {
        return this.m_jndiName;
    }

    public String getName() {
        return "Mail Service";
    }

    protected String getPassword() {
        return this.m_password;
    }

    protected String getUser() {
        return this.m_user;
    }

    public void setConfigurationFile(String file) {
        this.m_properties = file;
    }

    public void setJNDIName(String name) {
        this.m_jndiName = name;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void startService() throws Exception {
        InputStream is;
        final PasswordAuthentication pa = new PasswordAuthentication(this.getUser(), this.getPassword());
        Authenticator a = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return pa;
            }
        };
        String properties = this.getConfigurationFile();
        if (properties == null) {
            properties = "mail.properties";
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(properties)) == null) {
            throw new FileNotFoundException("Cannot find file '" + properties + "'");
        }
        Properties p = new Properties();
        p.load(is);
        Session session = Session.getInstance((Properties)p, (Authenticator)a);
        this.bind(session);
    }

    public void stopService() {
        try {
            this.unbind();
        }
        catch (NamingException x) {
            this.log.error("unbind failure", x);
        }
    }

    private void unbind() throws NamingException {
        if (this.m_bindName != null) {
            new InitialContext().unbind(this.m_bindName);
            NonSerializableFactory.unbind(this.m_bindName);
            this.log.info("Mail service '" + this.getJNDIName() + "' removed from JNDI");
        }
    }
}

