/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.SessionMetaData;
import org.w3c.dom.Element;

public class ApplicationMetaData
extends MetaData {
    private static Logger log = Logger.getLogger(class$org$jboss$metadata$ApplicationMetaData != null ? class$org$jboss$metadata$ApplicationMetaData : (class$org$jboss$metadata$ApplicationMetaData = ApplicationMetaData.class$("org.jboss.metadata.ApplicationMetaData")));
    private URL url;
    private ArrayList beans = new ArrayList();
    private ArrayList securityRoles = new ArrayList();
    private HashMap configurations = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap plugins = new HashMap();
    private String securityDomain;
    private String unauthenticatedPrincipal;
    private boolean enforceEjbRestrictions;
    static /* synthetic */ Class class$org$jboss$metadata$ApplicationMetaData;

    public ApplicationMetaData() {
    }

    public ApplicationMetaData(URL u) {
        this.url = u;
    }

    public void addPluginData(String pluginName, Object pluginData) {
        this.plugins.put(pluginName, pluginData);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public BeanMetaData getBeanByEjbName(String ejbName) {
        Iterator iterator = this.getEnterpriseBeans();
        while (iterator.hasNext()) {
            BeanMetaData current = (BeanMetaData)iterator.next();
            if (!current.getEjbName().equals(ejbName)) continue;
            return current;
        }
        return null;
    }

    public ConfigurationMetaData getConfigurationMetaDataByName(String name) {
        return (ConfigurationMetaData)this.configurations.get(name);
    }

    public Iterator getConfigurations() {
        return this.configurations.values().iterator();
    }

    public boolean getEnforceEjbRestrictions() {
        return this.enforceEjbRestrictions;
    }

    public Iterator getEnterpriseBeans() {
        return ((AbstractList)this.beans).iterator();
    }

    public Object getPluginData(String pluginName) {
        return this.plugins.get(pluginName);
    }

    public String getResourceByName(String name) {
        return (String)this.resources.get(name);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public URL getUrl() {
        return this.url;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Element enterpriseBeans = MetaData.getUniqueChild(element, "enterprise-beans");
        Iterator iterator = MetaData.getChildrenByTagName(enterpriseBeans, "entity");
        while (iterator.hasNext()) {
            Element currentEntity = (Element)iterator.next();
            EntityMetaData entityMetaData = new EntityMetaData(this);
            try {
                entityMetaData.importEjbJarXml(currentEntity);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for Entity Bean " + entityMetaData.getEjbName() + ": " + e.getMessage());
            }
            this.beans.add(entityMetaData);
        }
        iterator = MetaData.getChildrenByTagName(enterpriseBeans, "session");
        while (iterator.hasNext()) {
            Element currentSession = (Element)iterator.next();
            SessionMetaData sessionMetaData = new SessionMetaData(this);
            try {
                sessionMetaData.importEjbJarXml(currentSession);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for Session Bean " + sessionMetaData.getEjbName() + ": " + e.getMessage());
            }
            this.beans.add(sessionMetaData);
        }
        iterator = MetaData.getChildrenByTagName(enterpriseBeans, "message-driven");
        while (iterator.hasNext()) {
            Element currentMessageDriven = (Element)iterator.next();
            MessageDrivenMetaData messageDrivenMetaData = new MessageDrivenMetaData(this);
            try {
                messageDrivenMetaData.importEjbJarXml(currentMessageDriven);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for Message Driven Bean " + messageDrivenMetaData.getEjbName() + ": " + e.getMessage());
            }
            this.beans.add(messageDrivenMetaData);
        }
        Element assemblyDescriptor = MetaData.getOptionalChild(element, "assembly-descriptor");
        if (assemblyDescriptor != null) {
            iterator = MetaData.getChildrenByTagName(assemblyDescriptor, "security-role");
            while (iterator.hasNext()) {
                Element securityRole = (Element)iterator.next();
                try {
                    String role = MetaData.getElementContent(MetaData.getUniqueChild(securityRole, "role-name"));
                    this.securityRoles.add(role);
                }
                catch (DeploymentException e) {
                    throw new DeploymentException("Error in ejb-jar.xml for security-role: " + e.getMessage());
                }
            }
            iterator = MetaData.getChildrenByTagName(assemblyDescriptor, "method-permission");
            try {
                while (iterator.hasNext()) {
                    Element methodPermission = (Element)iterator.next();
                    Element unchecked = MetaData.getOptionalChild(methodPermission, "unchecked");
                    boolean isUnchecked = false;
                    HashSet<String> roles = null;
                    if (unchecked != null) {
                        isUnchecked = true;
                    } else {
                        roles = new HashSet<String>();
                        Iterator rolesIterator = MetaData.getChildrenByTagName(methodPermission, "role-name");
                        while (rolesIterator.hasNext()) {
                            roles.add(MetaData.getElementContent((Element)rolesIterator.next()));
                        }
                        if (roles.size() == 0) {
                            throw new DeploymentException("An unchecked element or one or more role-name elements must be specified in method-permission");
                        }
                    }
                    Iterator methods = MetaData.getChildrenByTagName(methodPermission, "method");
                    while (methods.hasNext()) {
                        MethodMetaData method = new MethodMetaData();
                        method.importEjbJarXml((Element)methods.next());
                        if (isUnchecked) {
                            method.setUnchecked();
                        } else {
                            method.setRoles(roles);
                        }
                        BeanMetaData bean = this.getBeanByEjbName(method.getEjbName());
                        if (bean == null) {
                            throw new DeploymentException(String.valueOf(method.getEjbName()) + " doesn't exist");
                        }
                        bean.addPermissionMethod(method);
                    }
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml, in method-permission: " + e.getMessage());
            }
            iterator = MetaData.getChildrenByTagName(assemblyDescriptor, "container-transaction");
            try {
                while (iterator.hasNext()) {
                    int transactionType;
                    Element containerTransaction = (Element)iterator.next();
                    String type = MetaData.getElementContent(MetaData.getUniqueChild(containerTransaction, "trans-attribute"));
                    if (type.equalsIgnoreCase("NotSupported") || type.equalsIgnoreCase("Not_Supported")) {
                        transactionType = 0;
                    } else if (type.equalsIgnoreCase("Supports")) {
                        transactionType = 2;
                    } else if (type.equalsIgnoreCase("Required")) {
                        transactionType = 1;
                    } else if (type.equalsIgnoreCase("RequiresNew") || type.equalsIgnoreCase("Requires_New")) {
                        transactionType = 3;
                    } else if (type.equalsIgnoreCase("Mandatory")) {
                        transactionType = 4;
                    } else if (type.equalsIgnoreCase("Never")) {
                        transactionType = 5;
                    } else {
                        throw new DeploymentException("invalid transaction-attribute : " + type);
                    }
                    Iterator methods = MetaData.getChildrenByTagName(containerTransaction, "method");
                    while (methods.hasNext()) {
                        MethodMetaData method = new MethodMetaData();
                        method.importEjbJarXml((Element)methods.next());
                        method.setTransactionType((byte)transactionType);
                        BeanMetaData bean = this.getBeanByEjbName(method.getEjbName());
                        if (bean == null) {
                            throw new DeploymentException("bean " + method.getEjbName() + " doesn't exist");
                        }
                        bean.addTransactionMethod(method);
                    }
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml, in container-transaction: " + e.getMessage());
            }
            Element excludeList = MetaData.getOptionalChild(assemblyDescriptor, "exclude-list");
            if (excludeList != null) {
                iterator = MetaData.getChildrenByTagName(excludeList, "method");
                while (iterator.hasNext()) {
                    Element methodInf = (Element)iterator.next();
                    MethodMetaData method = new MethodMetaData();
                    method.importEjbJarXml(methodInf);
                    method.setExcluded();
                    BeanMetaData bean = this.getBeanByEjbName(method.getEjbName());
                    if (bean == null) {
                        throw new DeploymentException("bean " + method.getEjbName() + " doesn't exist");
                    }
                    bean.addExcludedMethod(method);
                }
            }
        }
    }

    public void importJbossXml(Element element) throws DeploymentException {
        Element resmans;
        Element entBeans;
        Iterator iterator;
        Element confs;
        Element unauth;
        Element securityDomainElement;
        Element enforce = MetaData.getOptionalChild(element, "enforce-ejb-restrictions");
        if (enforce != null) {
            String tmp = MetaData.getElementContent(enforce);
            this.enforceEjbRestrictions = Boolean.valueOf(tmp);
        }
        if ((securityDomainElement = MetaData.getOptionalChild(element, "security-domain")) != null) {
            this.securityDomain = MetaData.getElementContent(securityDomainElement);
            if (this.securityDomain != null && this.securityDomain.length() == 0) {
                this.securityDomain = null;
            }
        }
        if ((unauth = MetaData.getOptionalChild(element, "unauthenticated-principal")) != null) {
            this.unauthenticatedPrincipal = MetaData.getElementContent(unauth);
        }
        if ((confs = MetaData.getOptionalChild(element, "container-configurations")) != null) {
            iterator = MetaData.getChildrenByTagName(confs, "container-configuration");
            while (iterator.hasNext()) {
                Element conf = (Element)iterator.next();
                String confName = MetaData.getElementContent(MetaData.getUniqueChild(conf, "container-name"));
                String parentConfName = conf.getAttribute("extends");
                if (parentConfName != null && parentConfName.trim().length() == 0) {
                    parentConfName = null;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Loading container-configuration, container-name=" + confName + ", extends=" + parentConfName);
                }
                ConfigurationMetaData configurationMetaData = null;
                if (parentConfName != null) {
                    configurationMetaData = this.getConfigurationMetaDataByName(parentConfName);
                    configurationMetaData = (ConfigurationMetaData)configurationMetaData.clone();
                    this.configurations.put(confName, configurationMetaData);
                }
                if (configurationMetaData == null) {
                    configurationMetaData = this.getConfigurationMetaDataByName(confName);
                }
                if (configurationMetaData == null) {
                    configurationMetaData = new ConfigurationMetaData(confName);
                    this.configurations.put(confName, configurationMetaData);
                }
                try {
                    configurationMetaData.importJbossXml(conf);
                }
                catch (DeploymentException e) {
                    throw new DeploymentException("Error in jboss.xml for container-configuration " + configurationMetaData.getName() + ": " + e.getMessage());
                }
            }
        }
        if ((entBeans = MetaData.getOptionalChild(element, "enterprise-beans")) != null) {
            String ejbName = null;
            try {
                BeanMetaData beanMetaData;
                Element bean;
                iterator = MetaData.getChildrenByTagName(entBeans, "entity");
                while (iterator.hasNext()) {
                    bean = (Element)iterator.next();
                    ejbName = MetaData.getElementContent(MetaData.getUniqueChild(bean, "ejb-name"));
                    beanMetaData = this.getBeanByEjbName(ejbName);
                    if (beanMetaData == null) {
                        throw new DeploymentException("found in jboss.xml but not in ejb-jar.xml");
                    }
                    beanMetaData.importJbossXml(bean);
                }
                iterator = MetaData.getChildrenByTagName(entBeans, "session");
                while (iterator.hasNext()) {
                    bean = (Element)iterator.next();
                    ejbName = MetaData.getElementContent(MetaData.getUniqueChild(bean, "ejb-name"));
                    beanMetaData = this.getBeanByEjbName(ejbName);
                    if (beanMetaData == null) {
                        throw new DeploymentException("found in jboss.xml but not in ejb-jar.xml");
                    }
                    beanMetaData.importJbossXml(bean);
                }
                iterator = MetaData.getChildrenByTagName(entBeans, "message-driven");
                while (iterator.hasNext()) {
                    bean = (Element)iterator.next();
                    ejbName = MetaData.getElementContent(MetaData.getUniqueChild(bean, "ejb-name"));
                    beanMetaData = this.getBeanByEjbName(ejbName);
                    if (beanMetaData == null) {
                        throw new DeploymentException("found in jboss.xml but not in ejb-jar.xml");
                    }
                    beanMetaData.importJbossXml(bean);
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in jboss.xml for Bean " + ejbName + ": " + e.getMessage());
            }
        }
        if ((resmans = MetaData.getOptionalChild(element, "resource-managers")) != null) {
            iterator = MetaData.getChildrenByTagName(resmans, "resource-manager");
            try {
                while (iterator.hasNext()) {
                    Element resourceManager = (Element)iterator.next();
                    String resName = MetaData.getElementContent(MetaData.getUniqueChild(resourceManager, "res-name"));
                    String jndi = MetaData.getElementContent(MetaData.getOptionalChild(resourceManager, "res-jndi-name"));
                    String url = MetaData.getElementContent(MetaData.getOptionalChild(resourceManager, "res-url"));
                    if (jndi != null && url == null) {
                        this.resources.put(resName, jndi);
                        continue;
                    }
                    if (jndi == null && url != null) {
                        this.resources.put(resName, url);
                        continue;
                    }
                    throw new DeploymentException(String.valueOf(resName) + " : expected res-url or res-jndi-name tag");
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in jboss.xml, in resource-manager: " + e.getMessage());
            }
        }
    }

    public void setUrl(URL u) {
        this.url = u;
    }
}

