/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SimplePrincipal;
import org.w3c.dom.Element;

public abstract class BeanMetaData
extends MetaData {
    public static final char SESSION_TYPE = 'S';
    public static final char ENTITY_TYPE = 'E';
    public static final char MDB_TYPE = 'M';
    private ApplicationMetaData application;
    private String ejbName;
    private String homeClass;
    private String remoteClass;
    private String localHomeClass;
    private String localClass;
    private String ejbClass;
    protected char beanType;
    protected boolean containerManagedTx = true;
    private ArrayList environmentEntries = new ArrayList();
    private HashMap ejbReferences = new HashMap();
    private HashMap ejbLocalReferences = new HashMap();
    private ArrayList securityRoleReferences = new ArrayList();
    private SecurityIdentityMetaData securityIdentity = null;
    private HashMap resourceReferences = new HashMap();
    private HashMap resourceEnvReferences = new HashMap();
    private ArrayList permissionMethods = new ArrayList();
    private ArrayList transactionMethods = new ArrayList();
    private ArrayList excludedMethods = new ArrayList();
    private String jndiName;
    private String localJndiName;
    protected String configurationName;
    private ConfigurationMetaData configuration;
    private String securityProxy;

    public BeanMetaData(ApplicationMetaData app, char beanType) {
        this.application = app;
        this.beanType = beanType;
    }

    public void addExcludedMethod(MethodMetaData method) {
        this.excludedMethods.add(method);
    }

    public void addPermissionMethod(MethodMetaData method) {
        if (method.isUnchecked()) {
            this.permissionMethods.add(0, method);
        } else {
            this.permissionMethods.add(method);
        }
    }

    public void addTransactionMethod(MethodMetaData method) {
        this.transactionMethods.add(method);
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.application;
    }

    public String getConfigurationName() {
        if (this.configurationName == null) {
            this.configurationName = this.getDefaultConfigurationName();
        }
        return this.configurationName;
    }

    public ConfigurationMetaData getContainerConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.application.getConfigurationMetaDataByName(this.getConfigurationName());
        }
        return this.configuration;
    }

    public abstract String getDefaultConfigurationName();

    public String getEjbClass() {
        return this.ejbClass;
    }

    public EjbLocalRefMetaData getEjbLocalRefByName(String name) {
        return (EjbLocalRefMetaData)this.ejbLocalReferences.get(name);
    }

    public Iterator getEjbLocalReferences() {
        return this.ejbLocalReferences.values().iterator();
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public EjbRefMetaData getEjbRefByName(String name) {
        return (EjbRefMetaData)this.ejbReferences.get(name);
    }

    public Iterator getEjbReferences() {
        return this.ejbReferences.values().iterator();
    }

    public Iterator getEnvironmentEntries() {
        return ((AbstractList)this.environmentEntries).iterator();
    }

    public Iterator getExcludedMethods() {
        return ((AbstractList)this.excludedMethods).iterator();
    }

    public String getHome() {
        return this.homeClass;
    }

    public String getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = this.ejbName;
        }
        return this.jndiName;
    }

    public String getLocal() {
        return this.localClass;
    }

    public String getLocalHome() {
        return this.localHomeClass;
    }

    public String getLocalJndiName() {
        if (this.localJndiName == null) {
            this.localJndiName = "local/" + this.ejbName;
        }
        return this.localJndiName;
    }

    public Set getMethodPermissions(String methodName, Class[] params, boolean remote) {
        MethodMetaData m;
        HashSet<Object> result = new HashSet<Object>();
        Iterator iterator = this.getExcludedMethods();
        while (iterator.hasNext()) {
            m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, remote)) continue;
            result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return result;
        }
        iterator = this.getPermissionMethods();
        while (iterator.hasNext()) {
            m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, remote)) continue;
            if (m.isUnchecked()) {
                result.clear();
                result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
                break;
            }
            Iterator rolesIterator = m.getRoles().iterator();
            while (rolesIterator.hasNext()) {
                String roleName = (String)rolesIterator.next();
                result.add(new SimplePrincipal(roleName));
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public byte getMethodTransactionType(String methodName, Class[] params, boolean remote) {
        byte result = 6;
        Iterator iterator = this.getTransactionMethods();
        while (iterator.hasNext()) {
            MethodMetaData m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, remote)) continue;
            result = m.getTransactionType();
            if (!"*".equals(m.getMethodName())) break;
        }
        return result;
    }

    public Iterator getPermissionMethods() {
        return ((AbstractList)this.permissionMethods).iterator();
    }

    public String getRemote() {
        return this.remoteClass;
    }

    public Iterator getResourceEnvReferences() {
        return this.resourceEnvReferences.values().iterator();
    }

    public Iterator getResourceReferences() {
        return this.resourceReferences.values().iterator();
    }

    public SecurityIdentityMetaData getSecurityIdentityMetaData() {
        return this.securityIdentity;
    }

    public String getSecurityProxy() {
        return this.securityProxy;
    }

    public Iterator getSecurityRoleReferences() {
        return ((AbstractList)this.securityRoleReferences).iterator();
    }

    public Iterator getTransactionMethods() {
        return ((AbstractList)this.transactionMethods).iterator();
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Element resourceRef;
        this.ejbName = MetaData.getElementContent(MetaData.getUniqueChild(element, "ejb-name"));
        if (!this.isMessageDriven()) {
            this.homeClass = MetaData.getElementContent(MetaData.getOptionalChild(element, "home"));
            this.remoteClass = MetaData.getElementContent(MetaData.getOptionalChild(element, "remote"));
            this.localHomeClass = MetaData.getElementContent(MetaData.getOptionalChild(element, "local-home"));
            this.localClass = MetaData.getElementContent(MetaData.getOptionalChild(element, "local"));
        }
        this.ejbClass = MetaData.getElementContent(MetaData.getUniqueChild(element, "ejb-class"));
        Iterator iterator = MetaData.getChildrenByTagName(element, "env-entry");
        while (iterator.hasNext()) {
            Element envEntry = (Element)iterator.next();
            EnvEntryMetaData envEntryMetaData = new EnvEntryMetaData();
            envEntryMetaData.importEjbJarXml(envEntry);
            this.environmentEntries.add(envEntryMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            EjbRefMetaData ejbRefMetaData = new EjbRefMetaData();
            ejbRefMetaData.importEjbJarXml(ejbRef);
            this.ejbReferences.put(ejbRefMetaData.getName(), ejbRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "ejb-local-ref");
        while (iterator.hasNext()) {
            Element ejbLocalRef = (Element)iterator.next();
            EjbLocalRefMetaData ejbLocalRefMetaData = new EjbLocalRefMetaData();
            ejbLocalRefMetaData.importEjbJarXml(ejbLocalRef);
            this.ejbLocalReferences.put(ejbLocalRefMetaData.getName(), ejbLocalRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "security-role-ref");
        while (iterator.hasNext()) {
            Element secRoleRef = (Element)iterator.next();
            SecurityRoleRefMetaData securityRoleRefMetaData = new SecurityRoleRefMetaData();
            securityRoleRefMetaData.importEjbJarXml(secRoleRef);
            this.securityRoleReferences.add(securityRoleRefMetaData);
        }
        Element securityIdentityElement = MetaData.getOptionalChild(element, "security-identity");
        if (securityIdentityElement != null) {
            this.securityIdentity = new SecurityIdentityMetaData();
            this.securityIdentity.importEjbJarXml(securityIdentityElement);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceRefMetaData resourceRefMetaData = new ResourceRefMetaData();
            resourceRefMetaData.importEjbJarXml(resourceRef);
            this.resourceReferences.put(resourceRefMetaData.getRefName(), resourceRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceEnvRefMetaData refMetaData = new ResourceEnvRefMetaData();
            refMetaData.importEjbJarXml(resourceRef);
            this.resourceEnvReferences.put(refMetaData.getRefName(), refMetaData);
        }
        this.trim();
    }

    public void importJbossXml(Element element) throws DeploymentException {
        String resRefName;
        Element resourceRef;
        this.jndiName = MetaData.getElementContent(MetaData.getOptionalChild(element, "jndi-name"));
        this.localJndiName = MetaData.getElementContent(MetaData.getOptionalChild(element, "local-jndi-name"));
        this.configurationName = MetaData.getElementContent(MetaData.getOptionalChild(element, "configuration-name"));
        if (this.configurationName != null && this.getApplicationMetaData().getConfigurationMetaDataByName(this.configurationName) == null) {
            throw new DeploymentException("configuration '" + this.configurationName + "' not found in standardjboss.xml or jboss.xml");
        }
        this.securityProxy = MetaData.getElementContent(MetaData.getOptionalChild(element, "security-proxy"), this.securityProxy);
        Iterator iterator = MetaData.getChildrenByTagName(element, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = MetaData.getElementContent(MetaData.getUniqueChild(resourceRef, "res-ref-name"));
            ResourceRefMetaData resourceRefMetaData = (ResourceRefMetaData)this.resourceReferences.get(resRefName);
            if (resourceRefMetaData == null) {
                throw new DeploymentException("resource-ref " + resRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            resourceRefMetaData.importJbossXml(resourceRef);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = MetaData.getElementContent(MetaData.getUniqueChild(resourceRef, "resource-env-ref-name"));
            ResourceEnvRefMetaData refMetaData = (ResourceEnvRefMetaData)this.resourceEnvReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-env-ref " + resRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            refMetaData.importJbossXml(resourceRef);
        }
        iterator = MetaData.getChildrenByTagName(element, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            String ejbRefName = MetaData.getElementContent(MetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
            EjbRefMetaData ejbRefMetaData = this.getEjbRefByName(ejbRefName);
            if (ejbRefMetaData == null) {
                throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            ejbRefMetaData.importJbossXml(ejbRef);
        }
        this.trim();
    }

    public boolean isBeanManagedTx() {
        return this.containerManagedTx ^ true;
    }

    public boolean isContainerManagedTx() {
        return this.containerManagedTx;
    }

    public boolean isEntity() {
        return this.beanType == 'E';
    }

    public boolean isMessageDriven() {
        return this.beanType == 'M';
    }

    public boolean isSession() {
        return this.beanType == 'S';
    }

    public void trim() {
        if (this.ejbName != null) {
            this.ejbName = this.ejbName.trim();
        }
        if (this.homeClass != null) {
            this.homeClass = this.homeClass.trim();
        }
        if (this.remoteClass != null) {
            this.remoteClass = this.remoteClass.trim();
        }
        if (this.localHomeClass != null) {
            this.localHomeClass = this.localHomeClass.trim();
        }
        if (this.localClass != null) {
            this.localClass = this.localClass.trim();
        }
        if (this.ejbClass != null) {
            this.ejbClass = this.ejbClass.trim();
        }
        if (this.jndiName != null) {
            this.jndiName = this.jndiName.trim();
        }
        if (this.localJndiName != null) {
            this.localJndiName = this.localJndiName.trim();
        }
        if (this.configurationName != null) {
            this.configurationName = this.configurationName.trim();
        }
        if (this.securityProxy != null) {
            this.securityProxy = this.securityProxy.trim();
        }
    }
}

