/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class WebMetaData
implements XmlLoadable {
    private HashMap resourceReferences = new HashMap();
    private HashMap resourceEnvReferences = new HashMap();
    private ArrayList environmentEntries = new ArrayList();
    private HashMap ejbReferences = new HashMap();
    private HashMap ejbLocalReferences = new HashMap();
    private ArrayList securityRoleReferences = new ArrayList();
    private String securityDomain;
    private String contextRoot;
    private String virtualHost;

    public String getContextRoot() {
        return this.contextRoot;
    }

    public Iterator getEjbLocalReferences() {
        return this.ejbLocalReferences.values().iterator();
    }

    public Iterator getEjbReferences() {
        return this.ejbReferences.values().iterator();
    }

    public Iterator getEnvironmentEntries() {
        return ((AbstractList)this.environmentEntries).iterator();
    }

    public Iterator getResourceEnvReferences() {
        return this.resourceEnvReferences.values().iterator();
    }

    public Iterator getResourceReferences() {
        return this.resourceReferences.values().iterator();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    protected void importJBossWebXml(Element jbossWeb) throws Exception {
        MetaData refMetaData;
        String resRefName;
        Element resourceRef;
        Element virtualHostElement;
        Element securityDomainElement;
        Element contextRootElement = MetaData.getOptionalChild(jbossWeb, "context-root");
        if (contextRootElement != null) {
            this.contextRoot = MetaData.getElementContent(contextRootElement);
        }
        if ((securityDomainElement = MetaData.getOptionalChild(jbossWeb, "security-domain")) != null) {
            this.securityDomain = MetaData.getElementContent(securityDomainElement);
        }
        if ((virtualHostElement = MetaData.getOptionalChild(jbossWeb, "virtual-host")) != null) {
            this.virtualHost = MetaData.getElementContent(virtualHostElement);
        }
        Iterator iterator = MetaData.getChildrenByTagName(jbossWeb, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = MetaData.getElementContent(MetaData.getUniqueChild(resourceRef, "res-ref-name"));
            refMetaData = (ResourceRefMetaData)this.resourceReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-ref " + resRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ResourceRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = MetaData.getChildrenByTagName(jbossWeb, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = MetaData.getElementContent(MetaData.getUniqueChild(resourceRef, "resource-env-ref-name"));
            refMetaData = (ResourceEnvRefMetaData)this.resourceEnvReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-env-ref " + resRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ResourceEnvRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = MetaData.getChildrenByTagName(jbossWeb, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            String ejbRefName = MetaData.getElementContent(MetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
            EjbRefMetaData ejbRefMetaData = (EjbRefMetaData)this.ejbReferences.get(ejbRefName);
            if (ejbRefMetaData == null) {
                throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss-web.xml but not in web.xml");
            }
            ejbRefMetaData.importJbossXml(ejbRef);
        }
    }

    protected void importWebXml(Element webApp) throws Exception {
        MetaData ejbRefMetaData;
        Element ejbRef;
        Element resourceRef;
        Iterator iterator = MetaData.getChildrenByTagName(webApp, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceRefMetaData resourceRefMetaData = new ResourceRefMetaData();
            resourceRefMetaData.importEjbJarXml(resourceRef);
            this.resourceReferences.put(resourceRefMetaData.getRefName(), resourceRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(webApp, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceEnvRefMetaData refMetaData = new ResourceEnvRefMetaData();
            refMetaData.importEjbJarXml(resourceRef);
            this.resourceEnvReferences.put(refMetaData.getRefName(), refMetaData);
        }
        iterator = MetaData.getChildrenByTagName(webApp, "env-entry");
        while (iterator.hasNext()) {
            Element envEntry = (Element)iterator.next();
            EnvEntryMetaData envEntryMetaData = new EnvEntryMetaData();
            envEntryMetaData.importEjbJarXml(envEntry);
            this.environmentEntries.add(envEntryMetaData);
        }
        iterator = MetaData.getChildrenByTagName(webApp, "ejb-ref");
        while (iterator.hasNext()) {
            ejbRef = (Element)iterator.next();
            ejbRefMetaData = new EjbRefMetaData();
            ((EjbRefMetaData)ejbRefMetaData).importEjbJarXml(ejbRef);
            this.ejbReferences.put(((EjbRefMetaData)ejbRefMetaData).getName(), ejbRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(webApp, "ejb-local-ref");
        while (iterator.hasNext()) {
            ejbRef = (Element)iterator.next();
            ejbRefMetaData = new EjbLocalRefMetaData();
            ((EjbLocalRefMetaData)ejbRefMetaData).importEjbJarXml(ejbRef);
            this.ejbLocalReferences.put(((EjbLocalRefMetaData)ejbRefMetaData).getName(), ejbRefMetaData);
        }
    }

    public void importXml(Element element) throws Exception {
        String rootTag = element.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("web-app")) {
            this.importWebXml(element);
        } else if (rootTag.equals("jboss-web")) {
            this.importJBossWebXml(element);
        }
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }
}

