/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.jboss.monitor.DynamicMonitorMBean;
import org.jboss.util.ServiceMBeanSupport;

public class DynamicMonitor
extends ServiceMBeanSupport
implements DynamicMonitorMBean {
    private ArrayList attributes = new ArrayList();
    private String monitoredAttributes;

    public String getMonitoredAttributes() {
        return this.monitoredAttributes;
    }

    public String getName() {
        return "DynamicMonitor";
    }

    public HashMap monitoredAttributes() {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("Threads", new Integer(Thread.activeCount()));
        rtn.put("Free Memory", new Long(Runtime.getRuntime().freeMemory()));
        rtn.put("Total Memory", new Long(Runtime.getRuntime().totalMemory()));
        int i = 0;
        while (i < this.attributes.size()) {
            MonitoredAttribute attr = (MonitoredAttribute)this.attributes.get(i);
            Object obj = null;
            try {
                obj = this.getServer().getAttribute(attr.objectName, attr.attribute);
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
            rtn.put(attr.displayName, obj);
            ++i;
        }
        return rtn;
    }

    public String monitoredAttributesHTML() {
        StringBuffer output = new StringBuffer();
        output.append("<table width=\"1\" border=\"1\">");
        output.append("<tr><td>Threads</td><td>");
        output.append(Integer.toString(Thread.activeCount()));
        output.append("</td></tr>\n");
        output.append("<tr><td>Free Memory</td><td>");
        output.append(Long.toString(Runtime.getRuntime().freeMemory()));
        output.append("</td></tr>\n");
        output.append("<tr><td>Total Memory</td><td>");
        output.append(Long.toString(Runtime.getRuntime().totalMemory()));
        output.append("</td></tr>\n");
        int i = 0;
        while (i < this.attributes.size()) {
            MonitoredAttribute attr = (MonitoredAttribute)this.attributes.get(i);
            Object obj = null;
            try {
                obj = this.getServer().getAttribute(attr.objectName, attr.attribute);
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
            output.append("<tr><td>");
            output.append(attr.displayName);
            output.append("</td><td>");
            if (obj == null) {
                obj = "FAILED TO GET ATTRIBUTE!";
            }
            output.append(obj.toString());
            output.append("</td></tr>\n");
            ++i;
        }
        output.append("</table>");
        return output.toString();
    }

    public void setMonitoredAttributes(String attrs) {
        this.attributes.clear();
        StringTokenizer tokenizer = new StringTokenizer(attrs);
        while (tokenizer.hasMoreTokens()) {
            String displayName = tokenizer.nextToken();
            String objectName = tokenizer.nextToken();
            String attr = tokenizer.nextToken();
            MonitoredAttribute ma = null;
            try {
                ma = new MonitoredAttribute(displayName, objectName, attr);
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
            this.attributes.add(ma);
        }
    }

    private static class MonitoredAttribute {
        public ObjectName objectName;
        public String attribute;
        public String displayName;

        public MonitoredAttribute(String displayName, String oname, String attr) throws Exception {
            this.objectName = new ObjectName(oname);
            this.attribute = attr;
            this.displayName = displayName;
        }
    }
}

