/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.naming.ENCFactory;
import org.jboss.naming.NamingServiceMBean;
import org.jboss.util.ServiceMBeanSupport;
import org.jnp.server.Main;

public class NamingService
extends ServiceMBeanSupport
implements NamingServiceMBean {
    Main naming;
    static /* synthetic */ Class class$org$jboss$naming$NamingService;
    static /* synthetic */ Class class$org$jboss$naming$ENCFactory;

    public NamingService() {
        String categoryName = (class$org$jboss$naming$NamingService != null ? class$org$jboss$naming$NamingService : (class$org$jboss$naming$NamingService = NamingService.class$("org.jboss.naming.NamingService"))).getName();
        this.naming = new Main(categoryName);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public int getBacklog() {
        return this.naming.getBacklog();
    }

    public String getBindAddress() {
        return this.naming.getBindAddress();
    }

    public String getClientSocketFactory() {
        return this.naming.getClientSocketFactory();
    }

    public String getName() {
        return "Naming";
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(":service=Naming");
    }

    public int getPort() {
        return this.naming.getPort();
    }

    public int getRmiPort() {
        return this.naming.getRmiPort();
    }

    public String getServerSocketFactory() {
        return this.naming.getServerSocketFactory();
    }

    public void initService() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("jndi.properties");
        Properties props = new Properties();
        props.load(is);
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            this.log.debug("System.setProperty, key=" + key + ", value=" + value);
            System.setProperty(key, value);
        }
    }

    public void setBacklog(int backlog) {
        this.naming.setBacklog(backlog);
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.naming.setBindAddress(host);
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.naming.setClientSocketFactory(factoryClassName);
    }

    public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.naming.setJNPServerSocketFactory(factoryClassName);
    }

    public void setPort(int port) {
        this.naming.setPort(port);
    }

    public void setRmiPort(int port) {
        this.naming.setRmiPort(port);
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.naming.setServerSocketFactory(factoryClassName);
    }

    public void startService() throws Exception {
        this.naming.start();
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        Enumeration<?> keys = env.keys();
        this.log.info("InitialContext Environment:");
        String providerURL = null;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)env.get(key);
            this.log.info("key=" + key + ", value=" + value);
            if (!key.equals("java.naming.provider.url")) continue;
            providerURL = value;
        }
        if (providerURL != null) {
            this.log.warn("Saw Context.PROVIDER_URL in server jndi.properties, url=" + providerURL);
        }
        ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
        ENCFactory.setTopClassLoader(topLoader);
        StringRefAddr refAddr = new StringRefAddr("nns", "ENC");
        Reference envRef = new Reference("javax.naming.Context", refAddr, (class$org$jboss$naming$ENCFactory != null ? class$org$jboss$naming$ENCFactory : (class$org$jboss$naming$ENCFactory = NamingService.class$("org.jboss.naming.ENCFactory"))).getName(), null);
        Context ctx = (Context)iniCtx.lookup("java:");
        ctx.rebind("comp", (Object)envRef);
        this.log.info("Naming started on port " + this.naming.getPort());
    }

    public void stopService() {
        this.naming.stop();
        this.log.info("JNP server stopped");
    }
}

