/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class ProxyAssembler {
    Vector cv = new Vector();
    Hashtable ct = new Hashtable();
    Hashtable ut = new Hashtable();
    short cn = 1;
    Vector members;
    AMember current;
    ByteArrayOutputStream code;
    Stack stack;
    String className;
    int modifiers;
    Class superClass;
    Class[] interfaces;
    private static final int opc_iconst_0 = 3;
    private static final int opc_bipush = 16;
    private static final int opc_sipush = 17;
    private static final int opc_ldc = 18;
    private static final int opc_ldc_w = 19;
    private static final int opc_ldc2_w = 20;
    private static final int opc_aaload = 50;
    private static final int opc_aastore = 83;
    private static final int opc_dup = 89;
    private static final int opc_getfield = 180;
    private static final int field_put = 1;
    private static final int field_static = -2;
    private static final int opc_invokevirtual = 182;
    private static final int opc_invokespecial = 183;
    private static final int opc_invokestatic = 184;
    private static final int opc_invokeinterface = 185;
    private static final int opc_new = 187;
    private static final int opc_newarray = 188;
    private static final int opc_anewarray = 189;
    private static final int opc_aload = 25;
    private static final int opc_aload_0 = 42;
    private static final int opc_wide = 196;
    private static final int opc_areturn = 176;
    private static final int opc_return = 177;
    private static final int opc_checkcast = 192;
    private static final int kind_a = 0;
    private static final int kind_i = -4;
    private static final int kind_l = -3;
    private static final int kind_f = -2;
    private static final int kind_d = -1;
    private static final int kind_b = 1;
    private static final int kind_c = 2;
    private static final int kind_s = 3;
    private static final int JAVA_MAGIC = -889275714;
    private static final short JAVA_VERSION = 45;
    private static final short JAVA_MINOR_VERSION = 3;
    private static final short CONSTANT_UTF8 = 1;
    private static final short CONSTANT_UNICODE = 2;
    private static final short CONSTANT_INTEGER = 3;
    private static final short CONSTANT_FLOAT = 4;
    private static final short CONSTANT_LONG = 5;
    private static final short CONSTANT_DOUBLE = 6;
    private static final short CONSTANT_CLASS = 7;
    private static final short CONSTANT_STRING = 8;
    private static final short CONSTANT_FIELD = 9;
    private static final short CONSTANT_METHOD = 10;
    private static final short CONSTANT_INTERFACEMETHOD = 11;
    private static final short CONSTANT_NAMEANDTYPE = 12;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;

    public ProxyAssembler(String className, int modifiers, Class superClass, Class[] interfaces) {
        if (interfaces == null) {
            interfaces = new Class[]{};
        }
        this.className = className;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.cv.addElement(null);
        this.members = new Vector();
        this.addMember(0, "", null, "");
    }

    public void addAttribute(String name, Object data) {
        this.addAttribute(this.current, name, data);
    }

    public void addAttribute(AMember m, String name, Object data) {
        if (m == null) {
            m = (AMember)this.members.elementAt(0);
        }
        Attr a = new Attr();
        a.name = name;
        a.data = data;
        m.attr.addElement(a);
    }

    void addExceptionAttribute(Class[] classes) {
        try {
            if (classes == null || classes.length == 0) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            short count = (short)classes.length;
            dos.writeShort(count);
            int iter = 0;
            while (iter < classes.length) {
                dos.writeShort(this.getClassIndex(classes[iter]));
                ++iter;
            }
            dos.flush();
            baos.flush();
            this.addAttribute("Exception", baos.toByteArray());
        }
        catch (IOException cantHappen) {
            cantHappen.printStackTrace();
        }
    }

    public Object addMember(int mods, Class rtype, String name, Class[] ptypes, Class[] exceptionClasses) {
        AMember m = this.addMember(mods, ProxyAssembler.getSig(rtype, ptypes), exceptionClasses, name);
        if (ptypes != null && this.stack.size() == 0) {
            if (!Modifier.isStatic(mods)) {
                this.declare(this);
            }
            int i = 0;
            while (i < ptypes.length) {
                this.declare(ptypes[i]);
                ++i;
            }
        }
        m.type = rtype;
        this.addExceptionAttribute(exceptionClasses);
        return m;
    }

    public Object addMember(int mods, Class type, Class[] exceptionClasses, String name) {
        return this.addMember(mods, type, name, null, exceptionClasses);
    }

    AMember addMember(int mods, String sig, Class[] exceptionClasses, String name) {
        String qsig = sig.substring(0, 1 + sig.indexOf(41));
        AMember m = this.findMember(qsig, name);
        if (m != null) {
            this.setCurrentMember(m);
            this.current.mods |= mods;
            this.modifiers |= mods & 0x400;
            return m;
        }
        m = new AMember();
        m.asm = this;
        if (ProxyAssembler.isMethodSig(sig)) {
            m.code = new ByteArrayOutputStream();
            m.stack = new Stack();
        }
        m.sig = sig;
        m.name = name;
        m.attr = new Vector();
        m.index = this.members.size();
        m.mods = mods;
        this.members.addElement(m);
        this.setCurrentMember(m);
        this.addExceptionAttribute(exceptionClasses);
        return m;
    }

    public void checkCast(Object t) {
        this.code.write(192);
        this.codeShort(this.getIndex(t));
        AValue se = (AValue)this.stack.pop();
        if (se.type instanceof Class && ((Class)se.type).isPrimitive()) {
            this.undeclare(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ProxyAssembler.class$("java.lang.Object")));
            this.declare(t);
        }
        se.type = t;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void codeShort(int v) {
        this.code.write(v >>> 8);
        this.code.write(v);
    }

    private void codeWide(int op, int n) {
        if (n < 256) {
            this.code.write(op);
            this.code.write(n);
        } else {
            this.code.write(196);
            this.code.write(op);
            this.codeShort(n);
        }
    }

    public int declare(Object t) {
        int n = this.current.sp++;
        if (t == Double.TYPE || t == Long.TYPE) {
            ++this.current.sp;
        }
        if (this.current.spmax < this.current.sp) {
            this.current.spmax = this.current.sp;
        }
        AValue se = new AValue();
        se.num = n;
        se.type = t;
        this.stack.push(se);
        return this.stack.size() - 1;
    }

    private int dofield(Object cls, String name, boolean isPut) {
        Class t;
        int mod;
        short fi = this.getMemberIndex(cls, name);
        Object x = this.cv.elementAt(fi);
        int op = 180;
        if (x instanceof Field) {
            Field f = (Field)x;
            mod = f.getModifiers();
            t = f.getType();
        } else {
            AMember m = (AMember)x;
            mod = m.mods;
            t = m.type;
        }
        if (isPut) {
            ++op;
            this.undeclare(t);
        }
        if (Modifier.isStatic(mod)) {
            op -= 2;
        } else {
            this.undeclare(cls);
        }
        this.code.write(op);
        this.codeShort(fi);
        return isPut ? -1 : this.declare(t);
    }

    public int dup() {
        this.code.write(89);
        return this.declare(this.stack.peek());
    }

    AMember findMember(String sig, String name) {
        int i = 0;
        while (i < this.members.size()) {
            AMember m = (AMember)this.members.elementAt(i);
            if (m.name.equals(name) && (!sig.startsWith("(") ? m.sig.startsWith("(") ^ true : m.sig.startsWith(sig))) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public short getClassIndex(Class c) {
        short ci = this.getUtfIndex(c.getName().replace('.', '/'));
        short[] data = new short[]{7, ci};
        return this.getIndex(data);
    }

    public byte[] getCode() {
        try {
            return this.internalGetCode();
        }
        catch (IOException ee) {
            throw new RuntimeException(ee.toString());
        }
    }

    public Object getCurrentMember() {
        return this.current;
    }

    public short getIndex(Object x) {
        Object n = this.ct.get(x);
        if (n == null) {
            short s = this.cn;
            this.cn = (short)(s + 1);
            n = new Short(s);
            this.ct.put(x, n);
            this.cv.addElement(x);
        }
        return (Short)n;
    }

    public short getMemberIndex(Object cls, String name) {
        return this.getMemberIndex(cls, name, null);
    }

    public short getMemberIndex(Object cls, String name, Class[] ptypes) {
        if (cls instanceof Class) {
            AccessibleObject m;
            Class c = (Class)cls;
            try {
                m = ptypes == null ? c.getField(name) : (name.equals("<init>") ? c.getConstructor(ptypes) : c.getMethod(name, ptypes));
            }
            catch (NoSuchMethodException ee) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(ee)) + " in " + c);
            }
            catch (NoSuchFieldException ee) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(ee)) + " in " + c);
            }
            return this.getIndex(m);
        }
        if (cls instanceof ProxyAssembler) {
            ProxyAssembler asm = (ProxyAssembler)cls;
            String sig = ProxyAssembler.getSig(null, ptypes);
            AMember m = asm.findMember(sig, name);
            if (m == null) {
                throw new IllegalArgumentException(String.valueOf(sig) + " " + name);
            }
            return this.getIndex(m);
        }
        throw new IllegalArgumentException("not a type: " + cls);
    }

    private byte[] getMethodCode(AMember m, ByteArrayOutputStream code) throws IOException {
        if (code.size() == 0) {
            if ((this.current.mods & 0x500) == 0) {
                this.current.mods |= 0x400;
                this.modifiers |= 0x400;
            }
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(code.size() + 30);
        DataOutputStream ds = new DataOutputStream(bytes);
        int slop = 10;
        int max_stack = this.current.locmax + slop;
        int max_locals = this.current.spmax + slop;
        ds.writeShort(max_stack);
        ds.writeShort(max_locals);
        ds.writeInt(code.size());
        code.writeTo(ds);
        ds.writeShort(0);
        Vector<Attr> attrs = new Vector<Attr>();
        int i = m.attr.size();
        while (--i >= 0) {
            Attr ma = (Attr)m.attr.elementAt(i);
            if (!ma.name.startsWith("Code.")) continue;
            m.attr.removeElementAt(i);
            ma.name = ma.name.substring("Code.".length());
            attrs.addElement(ma);
            this.getUtfIndex(ma.name);
        }
        this.writeAttrs(ds, attrs);
        return bytes.toByteArray();
    }

    public short getNTIndex(String name, String sig) {
        NameAndType nt = new NameAndType();
        nt.name = this.getUtfIndex(name);
        nt.sig = this.getUtfIndex(sig);
        return this.getIndex(nt);
    }

    public static String getSig(Class t) {
        if (t == null) {
            return "";
        }
        if (t.isPrimitive()) {
            if (t == Boolean.TYPE) {
                return "Z";
            }
            if (t == Character.TYPE) {
                return "C";
            }
            if (t == Byte.TYPE) {
                return "B";
            }
            if (t == Short.TYPE) {
                return "S";
            }
            if (t == Integer.TYPE) {
                return "I";
            }
            if (t == Long.TYPE) {
                return "J";
            }
            if (t == Float.TYPE) {
                return "F";
            }
            if (t == Double.TYPE) {
                return "D";
            }
            if (t == Void.TYPE) {
                return "V";
            }
            Class<?> a = Array.newInstance(t, 0).getClass();
            return ProxyAssembler.getSig(a).substring(1);
        }
        if (t.isArray()) {
            return t.getName().replace('.', '/');
        }
        return "L" + t.getName().replace('.', '/') + ";";
    }

    public static String getSig(Class rt, Class[] pt) {
        if (pt == null) {
            return ProxyAssembler.getSig(rt);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < pt.length) {
            sb.append(ProxyAssembler.getSig(pt[i]));
            ++i;
        }
        sb.append(")");
        sb.append(ProxyAssembler.getSig(rt));
        return sb.toString();
    }

    public short getUtfIndex(String x) {
        Object n = this.ut.get(x);
        if (n == null) {
            short s = this.cn;
            this.cn = (short)(s + 1);
            n = new Short(s);
            this.ut.put(x, n);
            int xlen = 2 + x.length();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(xlen);
            DataOutputStream ds = new DataOutputStream(bytes);
            try {
                ds.writeByte(1);
                ds.writeUTF(x);
            }
            catch (IOException ee) {
                throw new RuntimeException(ee.toString());
            }
            this.cv.addElement(bytes.toByteArray());
        }
        return (Short)n;
    }

    public byte[] internalGetCode() throws IOException {
        this.getIndex(this);
        this.getIndex(this.superClass);
        int i = 0;
        while (i < this.interfaces.length) {
            this.getIndex(this.interfaces[i]);
            ++i;
        }
        int nfields = 0;
        int nmethods = 0;
        int i2 = 0;
        while (i2 < this.members.size()) {
            byte[] codeAttr;
            AMember m = (AMember)this.members.elementAt(i2);
            if (m.code != null && (codeAttr = this.getMethodCode(m, m.code)) != null) {
                this.addAttribute(m, "Code", codeAttr);
            }
            int j = 0;
            while (j < m.attr.size()) {
                Attr a = (Attr)m.attr.elementAt(j);
                this.getUtfIndex(a.name);
                ++j;
            }
            if (m.name.length() != 0) {
                this.getUtfIndex(m.name);
                this.getUtfIndex(m.sig);
                if (ProxyAssembler.isMethodSig(m.sig)) {
                    ++nmethods;
                } else {
                    ++nfields;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.cv.size()) {
            Object x = this.cv.elementAt(i3);
            if (x != null) {
                Object m;
                if (x instanceof String) {
                    String s = (String)x;
                    short si = this.getUtfIndex(s);
                    short[] data = new short[]{8, si};
                    x = data;
                } else if (x instanceof Class) {
                    Class c = (Class)x;
                    short ci = this.getUtfIndex(c.getName().replace('.', '/'));
                    short[] data = new short[]{7, ci};
                    x = data;
                } else if (x instanceof Field) {
                    m = (Field)x;
                    short ci = this.getIndex(((Field)m).getDeclaringClass());
                    short nt = this.getNTIndex(((Field)m).getName(), ProxyAssembler.getSig(((Field)m).getType()));
                    short[] data = new short[]{9, ci, nt};
                    x = data;
                } else if (x instanceof Constructor) {
                    m = (Constructor)x;
                    short ci = this.getIndex(((Constructor)m).getDeclaringClass());
                    short nt = this.getNTIndex("<init>", ProxyAssembler.getSig(Void.TYPE, ((Constructor)m).getParameterTypes()));
                    short[] data = new short[]{10, ci, nt};
                    x = data;
                } else if (x instanceof Method) {
                    m = (Method)x;
                    Class<?> c = ((Method)m).getDeclaringClass();
                    short kind = c.isInterface() ? (short)11 : 10;
                    short ci = this.getIndex(c);
                    short nt = this.getNTIndex(((Method)m).getName(), ProxyAssembler.getSig(((Method)m).getReturnType(), ((Method)m).getParameterTypes()));
                    short[] data = new short[]{kind, ci, nt};
                    x = data;
                } else if (x instanceof ProxyAssembler) {
                    ProxyAssembler asm = (ProxyAssembler)x;
                    short ci = this.getUtfIndex(asm.className.replace('.', '/'));
                    short[] data = new short[]{7, ci};
                    x = data;
                } else if (x instanceof AMember) {
                    m = (AMember)x;
                    short kind = !ProxyAssembler.isMethodSig(((AMember)m).sig) ? (short)9 : (((AMember)m).asm.isInterface() ? (short)11 : 10);
                    short ci = this.getIndex(((AMember)m).asm);
                    short nt = this.getNTIndex(((AMember)m).name, ((AMember)m).sig);
                    short[] data = new short[]{kind, ci, nt};
                    x = data;
                } else if (x instanceof NameAndType) {
                    NameAndType nt = (NameAndType)x;
                    short[] data = new short[]{12, nt.name, nt.sig};
                    x = data;
                }
                this.cv.setElementAt(x, i3);
            }
            ++i3;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(400);
        DataOutputStream ds = new DataOutputStream(bytes);
        ds.writeInt(-889275714);
        ds.writeShort(3);
        ds.writeShort(45);
        int cvsize = this.cv.size();
        ds.writeShort(cvsize);
        int i4 = 0;
        while (i4 < this.cv.size()) {
            Object x = this.cv.elementAt(i4);
            if (x != null) {
                if (x instanceof short[]) {
                    short[] data = (short[])x;
                    ds.writeByte(data[0]);
                    int j = 1;
                    while (j < data.length) {
                        ds.writeShort(data[j]);
                        ++j;
                    }
                } else if (x instanceof byte[]) {
                    ds.write((byte[])x);
                } else if (x instanceof Integer) {
                    ds.writeByte(3);
                    ds.writeInt((Integer)x);
                } else {
                    throw new RuntimeException("unexpected");
                }
            }
            ++i4;
        }
        ds.writeShort(this.modifiers);
        ds.writeShort(this.getIndex(this));
        ds.writeShort(this.getIndex(this.superClass));
        ds.writeShort(this.interfaces.length);
        int i5 = 0;
        while (i5 < this.interfaces.length) {
            ds.writeShort(this.getIndex(this.interfaces[i5]));
            ++i5;
        }
        int pass = 0;
        while (pass <= 1) {
            boolean methods = pass > 0;
            ds.writeShort(methods ? nmethods : nfields);
            int i6 = 0;
            while (i6 < this.members.size()) {
                AMember m = (AMember)this.members.elementAt(i6);
                if (m.name.length() != 0 && ProxyAssembler.isMethodSig(m.sig) == methods) {
                    ds.writeShort(m.mods);
                    ds.writeShort(this.getUtfIndex(m.name));
                    ds.writeShort(this.getUtfIndex(m.sig));
                    this.writeAttrs(ds, m.attr);
                }
                ++i6;
            }
            ++pass;
        }
        AMember m0 = (AMember)this.members.elementAt(0);
        this.writeAttrs(ds, m0.attr);
        if (cvsize != this.cv.size()) {
            throw new RuntimeException("cvsize");
        }
        return bytes.toByteArray();
    }

    public int invoke(Object cls, String name, Class[] ptypes) {
        Class rtype;
        int mod;
        Object m;
        short mi = this.getMemberIndex(cls, name, ptypes);
        Object x = this.cv.elementAt(mi);
        int op = 182;
        if (x instanceof Method) {
            m = (Method)x;
            mod = ((Method)m).getModifiers();
            rtype = ((Method)m).getReturnType();
            if (((Method)m).getDeclaringClass().isInterface()) {
                op = 185;
            }
        } else if (x instanceof Constructor) {
            m = (Constructor)x;
            mod = ((Constructor)m).getModifiers();
            rtype = Void.TYPE;
            op = 183;
        } else {
            m = (AMember)x;
            mod = ((AMember)m).mods;
            rtype = ((AMember)m).type;
            if (((AMember)m).asm.isInterface()) {
                op = 185;
            }
        }
        if (Modifier.isStatic(mod)) {
            op = 184;
        } else {
            this.undeclare(cls);
        }
        int i = ptypes.length;
        while (--i >= 0) {
            this.undeclare(ptypes[i]);
        }
        this.code.write(op);
        this.codeShort(mi);
        return this.declare(rtype);
    }

    boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    private static boolean isMethodSig(String sig) {
        return sig.indexOf(40) >= 0;
    }

    public void pushConstant(int x) {
        this.pushConstant(new Integer(x));
    }

    public void pushConstant(Object x) {
        int op = 19;
        if (x instanceof Integer) {
            this.declare(Integer.TYPE);
            int v = (Integer)x;
            if (v >= -1 && v <= 5) {
                this.code.write(3 + v);
                return;
            }
            if (v > -128 && v < 128) {
                this.code.write(16);
                this.code.write(v);
                return;
            }
            if (v > Short.MIN_VALUE && v < 32768) {
                this.code.write(17);
                this.codeShort(v);
                return;
            }
        } else if (x instanceof Float) {
            this.declare(Float.TYPE);
        } else if (x instanceof String) {
            this.declare(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ProxyAssembler.class$("java.lang.String")));
        } else if (x instanceof Long) {
            this.declare(Long.TYPE);
            op = 20;
        } else if (x instanceof Double) {
            this.declare(Double.TYPE);
            op = 20;
        } else {
            throw new RuntimeException("unexpected: " + x);
        }
        short xi = this.getIndex(x);
        if (op == 19 && xi < 256) {
            this.code.write(18);
            this.code.write(xi);
        } else {
            this.code.write(op);
            this.codeShort(xi);
        }
    }

    public void pushElement(Object etype) {
        int kind = this.typeKind(etype, true);
        this.code.write(50 + kind);
        this.undeclare(Integer.TYPE);
        this.undeclare(null);
        this.declare(etype);
    }

    public int pushField(Object cls, String name) {
        return this.dofield(cls, name, false);
    }

    public int pushLocal(int loc) {
        if (this.current.locmax < loc) {
            this.current.locmax = loc;
        }
        AValue se = (AValue)this.stack.elementAt(loc);
        int kind = this.typeKind(se.type, false);
        if (se.num <= 3) {
            this.code.write(42 + kind * 4 + se.num);
        } else {
            this.codeWide(25 + kind, se.num);
        }
        return this.declare(se.type);
    }

    public int pushNewArray(Object etype) {
        Class t;
        int tcode;
        int kind = this.typeKind(etype, true);
        switch (kind) {
            case 0: {
                this.code.write(189);
                this.codeShort(this.getIndex(etype));
                return this.declare(array$Ljava$lang$Object != null ? array$Ljava$lang$Object : (array$Ljava$lang$Object = ProxyAssembler.class$("[Ljava.lang.Object;")));
            }
            case -2: {
                tcode = 6;
                t = array$F != null ? array$F : (array$F = ProxyAssembler.class$("[F"));
                break;
            }
            case -1: {
                tcode = 7;
                t = array$D != null ? array$D : (array$D = ProxyAssembler.class$("[D"));
                break;
            }
            case -4: {
                tcode = 10;
                t = array$I != null ? array$I : (array$I = ProxyAssembler.class$("[I"));
                break;
            }
            case -3: {
                tcode = 11;
                t = array$J != null ? array$J : (array$J = ProxyAssembler.class$("[J"));
                break;
            }
            case 1: {
                if (etype == Boolean.TYPE) {
                    tcode = 4;
                    t = array$Z != null ? array$Z : (array$Z = ProxyAssembler.class$("[Z"));
                    break;
                }
                tcode = 8;
                t = array$B != null ? array$B : (array$B = ProxyAssembler.class$("[B"));
                break;
            }
            case 2: {
                tcode = 5;
                t = array$C != null ? array$C : (array$C = ProxyAssembler.class$("[C"));
                break;
            }
            case 3: {
                tcode = 9;
                t = array$S != null ? array$S : (array$S = ProxyAssembler.class$("[S"));
                break;
            }
            default: {
                return 0;
            }
        }
        this.code.write(188);
        this.code.write(tcode);
        return this.declare(t);
    }

    public void ret() {
        if (this.current.sig.endsWith("V")) {
            this.code.write(177);
            return;
        }
        Class t = this.current.type;
        this.undeclare(t);
        this.code.write(176 + this.typeKind(t, false));
        this.stack = null;
    }

    public void setCurrentMember(Object m) {
        if (m == null) {
            m = this.members.elementAt(0);
        }
        this.current = (AMember)m;
        this.code = this.current.code;
        this.stack = this.current.stack;
    }

    public void setElement(Object etype) {
        int kind = this.typeKind(etype, true);
        this.code.write(83 + kind);
        this.undeclare(etype);
        this.undeclare(Integer.TYPE);
        this.undeclare(null);
    }

    public void setField(Object cls, String name) {
        this.dofield(cls, name, true);
    }

    private int typeKind(Object t, boolean subwords) {
        if (t != null && t instanceof Class && ((Class)t).isPrimitive()) {
            if (t == Float.TYPE) {
                return -2;
            }
            if (t == Long.TYPE) {
                return -3;
            }
            if (t == Double.TYPE) {
                return -1;
            }
            if (t == Integer.TYPE || !subwords) {
                return -4;
            }
            if (t == Character.TYPE) {
                return 2;
            }
            if (t == Short.TYPE) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public void undeclare(Object t) {
        AValue se = (AValue)this.stack.pop();
        this.current.sp = se.num;
    }

    private void writeAttrs(DataOutputStream ds, Vector attrs) throws IOException {
        ds.writeShort(attrs.size());
        int i = 0;
        while (i < attrs.size()) {
            Attr a = (Attr)attrs.elementAt(i);
            ds.writeShort(this.getUtfIndex(a.name));
            if (!(a.data instanceof byte[])) {
                throw new RuntimeException("unexpected");
            }
            byte[] xa = (byte[])a.data;
            ds.writeInt(xa.length);
            ds.write(xa);
            ++i;
        }
    }

    private static class AMember {
        int mods;
        int sp;
        int spmax;
        int locmax;
        int index;
        Class type;
        String sig;
        String name;
        Vector attr;
        Stack stack;
        ByteArrayOutputStream code;
        ProxyAssembler asm;

        AMember() {
        }
    }

    private static class Attr {
        String name;
        Object data;

        Attr() {
        }
    }

    private static class AValue {
        int num;
        Object type;

        AValue() {
        }
    }

    private static class NameAndType {
        short name;
        short sig;

        NameAndType() {
        }

        public boolean equals(Object x) {
            if (x instanceof NameAndType) {
                NameAndType that = (NameAndType)x;
                return that.name == this.name && that.sig == this.sig;
            }
            return false;
        }

        public int hashCode() {
            return this.name + this.sig * 1000;
        }
    }
}

