/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.ArrayList;
import javax.security.auth.Subject;

public final class SecurityAssociation {
    private static boolean server;
    private static Principal principal;
    private static Object credential;
    private static Subject subject;
    private static ThreadLocal threadPrincipal;
    private static ThreadLocal threadCredential;
    private static ThreadLocal threadSubject;
    private static RunAsThreadLocalStack threadRunAsStacks;
    private static final RuntimePermission getPrincipalInfoPermission;
    private static final RuntimePermission setPrincipalInfoPermission;
    private static final RuntimePermission setServerPermission;

    static {
        threadRunAsStacks = new RunAsThreadLocalStack();
        getPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getPrincipalInfo");
        setPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setPrincipalInfo");
        setServerPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setServer");
        boolean useThreadLocal = false;
        try {
            useThreadLocal = Boolean.getBoolean("org.jboss.security.SecurityAssociation.ThreadLocal");
        }
        catch (SecurityException securityException) {}
        if (useThreadLocal) {
            threadPrincipal = new ThreadLocal();
            threadCredential = new ThreadLocal();
            threadSubject = new ThreadLocal();
        } else {
            threadPrincipal = new InheritableThreadLocal();
            threadCredential = new InheritableThreadLocal();
            threadSubject = new InheritableThreadLocal();
        }
    }

    public static void clear() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadPrincipal.set(null);
            threadCredential.set(null);
            threadSubject.set(null);
        } else {
            principal = null;
            credential = null;
            subject = null;
        }
    }

    public static Object getCredential() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (server) {
            return threadCredential.get();
        }
        return credential;
    }

    public static Principal getPrincipal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (server) {
            return (Principal)threadPrincipal.get();
        }
        return principal;
    }

    public static Subject getSubject() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (server) {
            return (Subject)threadSubject.get();
        }
        return subject;
    }

    public static Principal peekRunAsRole() {
        Principal runAsRole = threadRunAsStacks.peek();
        return runAsRole;
    }

    public static Principal popRunAsRole() {
        Principal runAsRole = threadRunAsStacks.pop();
        return runAsRole;
    }

    public static void pushRunAsRole(Principal runAsRole) {
        threadRunAsStacks.push(runAsRole);
    }

    public static void setCredential(Object credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadCredential.set(credential);
        } else {
            SecurityAssociation.credential = credential;
        }
    }

    public static void setPrincipal(Principal principal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadPrincipal.set(principal);
        } else {
            SecurityAssociation.principal = principal;
        }
    }

    public static void setServer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        server = true;
    }

    public static void setSubject(Subject subject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadSubject.set(subject);
        } else {
            SecurityAssociation.subject = subject;
        }
    }

    private static class RunAsThreadLocalStack
    extends ThreadLocal {
        RunAsThreadLocalStack() {
        }

        protected Object initialValue() {
            return new ArrayList();
        }

        Principal peek() {
            ArrayList stack = (ArrayList)super.get();
            Principal runAs = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                runAs = (Principal)stack.get(lastIndex);
            }
            return runAs;
        }

        Principal pop() {
            ArrayList stack = (ArrayList)super.get();
            Principal runAs = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                runAs = (Principal)stack.remove(lastIndex);
            }
            return runAs;
        }

        void push(Principal runAs) {
            ArrayList stack = (ArrayList)super.get();
            stack.add(runAs);
        }
    }
}

