/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.jboss.tm.GlobalId;
import org.jboss.tm.TxCapsule;
import org.jboss.tm.TxManager;
import org.jboss.tm.XidImpl;

class TransactionImpl
implements Transaction {
    XidImpl xid;
    private volatile TxCapsule txCapsule;
    private GlobalId globalId;

    TransactionImpl(TxCapsule txCapsule, XidImpl xid) {
        this.txCapsule = txCapsule;
        this.xid = xid;
        this.globalId = new GlobalId(xid.hashCode(), xid.getInternalGlobalTransactionId());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.txCapsule == null) {
            throw new IllegalStateException("No transaction.");
        }
        this.txCapsule.commit();
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.txCapsule == null) {
            throw new IllegalStateException("No transaction.");
        }
        return this.txCapsule.delistResource(xaRes, flag);
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.txCapsule == null) {
            throw new IllegalStateException("No transaction.");
        }
        return this.txCapsule.enlistResource(xaRes);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TransactionImpl) {
            return this.xid.equals(((TransactionImpl)obj).xid);
        }
        return false;
    }

    GlobalId getGlobalId() {
        return this.globalId;
    }

    public int getStatus() throws SystemException {
        int status = 6;
        if (this.txCapsule != null) {
            status = this.txCapsule.getStatus();
        }
        return status;
    }

    public int hashCode() {
        return this.xid.hashCode();
    }

    boolean isDone() {
        return this.txCapsule == null;
    }

    public void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException, SystemException {
        if (this.txCapsule == null) {
            throw new IllegalStateException("No transaction.");
        }
        this.txCapsule.registerSynchronization(s);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.txCapsule == null) {
            throw new IllegalStateException("No transaction.");
        }
        this.txCapsule.rollback();
    }

    synchronized void setDone() {
        this.txCapsule = null;
        TxManager.getInstance().releaseTransactionImpl(this);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.txCapsule == null) {
            throw new IllegalStateException("No transaction.");
        }
        this.txCapsule.setRollbackOnly();
    }

    public String toString() {
        return "TransactionImpl:" + this.xid.toString();
    }
}

