/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.tm.TransactionManagerServiceMBean;
import org.jboss.tm.TxCapsule;
import org.jboss.tm.TxManager;
import org.jboss.util.ServiceMBeanSupport;

public class TransactionManagerService
extends ServiceMBeanSupport
implements TransactionManagerServiceMBean,
ObjectFactory {
    public static String JNDI_NAME = "java:/TransactionManager";
    public static String JNDI_IMPORTER = "java:/TransactionPropagationContextImporter";
    public static String JNDI_EXPORTER = "java:/TransactionPropagationContextExporter";
    private MBeanServer server;
    private int timeout = 300;
    private String xidClassName = null;
    static TxManager tm;
    static /* synthetic */ Class array$B;

    private void bindRef(String jndiName, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind(jndiName, (Object)ref);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getName() {
        return "Transaction manager";
    }

    public long getNumSuspendedTransactions() {
        return tm.getNumSuspendedTransactions();
    }

    public long getNumTransactions() {
        return tm.getNumTransactions();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return tm;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return new ObjectName(":service=TransactionManager");
    }

    public int getTransactionTimeout() {
        if (tm != null) {
            this.timeout = tm.getDefaultTransactionTimeout();
        }
        return this.timeout;
    }

    public String getXidClassName() {
        return this.xidClassName;
    }

    public void setTransactionTimeout(int timeout) {
        this.timeout = timeout;
        if (tm != null) {
            tm.setDefaultTransactionTimeout(timeout);
        }
    }

    public void setXidClassName(String name) {
        this.xidClassName = name;
    }

    protected void startService() throws Exception {
        if (this.xidClassName != null) {
            this.log.info("Using Xid class '" + this.xidClassName + "'");
            Class<?> cls = Class.forName(this.xidClassName);
            TxCapsule.xidConstructor = cls.getConstructor(Integer.TYPE, array$B != null ? array$B : (array$B = TransactionManagerService.class$("[B")), array$B != null ? array$B : (array$B = TransactionManagerService.class$("[B")));
        }
        tm = TxManager.getInstance();
        tm.setDefaultTransactionTimeout(this.timeout);
        this.bindRef(JNDI_NAME, "org.jboss.tm.TxManager");
        this.bindRef(JNDI_IMPORTER, "org.jboss.tm.TransactionPropagationContextImporter");
        this.bindRef(JNDI_EXPORTER, "org.jboss.tm.TransactionPropagationContextFactory");
    }

    protected void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(JNDI_NAME);
            ctx.unbind(JNDI_IMPORTER);
            ctx.unbind(JNDI_EXPORTER);
        }
        catch (Exception e) {
            this.log.error("stopService error", e);
        }
    }
}

