/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.XidImpl;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutFactory;
import org.jboss.util.timeout.TimeoutTarget;

class TxCapsule
implements TimeoutTarget {
    private static Logger log = Logger.getLogger(class$org$jboss$tm$TxCapsule != null ? class$org$jboss$tm$TxCapsule : (class$org$jboss$tm$TxCapsule = TxCapsule.class$("org.jboss.tm.TxCapsule")));
    private static final boolean trace = false;
    private static final int HEUR_NONE = 4;
    static Constructor xidConstructor = null;
    private static LinkedList inactiveCapsules = new LinkedList();
    private TransactionImpl transaction;
    private Synchronization[] sync = new Synchronization[1];
    private int syncAllocSize = 1;
    private int syncCount = 0;
    private XAResource[] resources = new XAResource[1];
    private int[] resourceState = new int[1];
    private static final int RS_NEW = 0;
    private static final int RS_ENLISTED = 1;
    private static final int RS_SUSPENDED = 2;
    private static final int RS_ENDED = 3;
    private static final int RS_VOTE_READONLY = 4;
    private static final int RS_VOTE_OK = 5;
    private int[] resourceSameRM = new int[1];
    private Xid[] resourceXids = new Xid[1];
    private int resourceAllocSize = 1;
    private int resourceCount = 0;
    private boolean resourcesEnded = false;
    private XidImpl xid = new XidImpl();
    private Object[] xidConstructorArgs = null;
    private int lastBranchId = 0;
    private int status;
    private int heuristicCode = 4;
    private long start;
    private Timeout timeout;
    private long incarnationCount = 1L;
    private boolean locked = false;
    private boolean done = false;
    static /* synthetic */ Class class$org$jboss$tm$TxCapsule;

    private TxCapsule(long timeout) {
        if (xidConstructor != null) {
            this.xidConstructorArgs = new Object[3];
            this.xidConstructorArgs[0] = new Integer(this.xid.getFormatId());
        }
        this.transaction = new TransactionImpl(this, this.xid);
        this.status = 0;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout(this.start + timeout, this);
    }

    private int addResource(XAResource xaRes, Xid branchXid, int idxSameRM) {
        if (this.resourceCount == this.resourceAllocSize) {
            this.resourceAllocSize = 2 * this.resourceAllocSize;
            XAResource[] res = new XAResource[this.resourceAllocSize];
            System.arraycopy(this.resources, 0, res, 0, this.resourceCount);
            this.resources = res;
            int[] stat = new int[this.resourceAllocSize];
            System.arraycopy(this.resourceState, 0, stat, 0, this.resourceCount);
            this.resourceState = stat;
            Xid[] xids = new Xid[this.resourceAllocSize];
            System.arraycopy(this.resourceXids, 0, xids, 0, this.resourceCount);
            this.resourceXids = xids;
            int[] sameRM = new int[this.resourceAllocSize];
            System.arraycopy(this.resourceSameRM, 0, sameRM, 0, this.resourceCount);
            this.resourceSameRM = sameRM;
        }
        this.resources[this.resourceCount] = xaRes;
        this.resourceState[this.resourceCount] = 0;
        this.resourceXids[this.resourceCount] = branchXid;
        this.resourceSameRM[this.resourceCount] = idxSameRM;
        return this.resourceCount++;
    }

    private void cancelTimeout() {
        if (this.timeout != null) {
            this.unlock();
            try {
                try {
                    this.timeout.cancel();
                }
                catch (Exception e) {
                    log.debug(e);
                }
                Object var2_2 = null;
                this.lock();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.lock();
                throw throwable;
            }
            this.timeout = null;
        }
    }

    private void checkHeuristics() throws HeuristicMixedException, HeuristicRollbackException {
        switch (this.heuristicCode) {
            case 5: 
            case 8: {
                this.heuristicCode = 4;
                throw new HeuristicMixedException();
            }
            case 6: {
                this.heuristicCode = 4;
                throw new HeuristicRollbackException();
            }
            case 7: {
                this.heuristicCode = 4;
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.lock();
            switch (this.status) {
                case 7: {
                    throw new IllegalStateException("Already started preparing.");
                }
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back.");
                }
                case 4: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already rolled back.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already committed.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                case 1: {
                    this.doBeforeCompletion();
                    this.endResources();
                    this.rollbackResources();
                    this.doAfterCompletion();
                    this.cancelTimeout();
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new RollbackException("Already marked for rollback");
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
                case 0: 
            }
            this.doBeforeCompletion();
            this.endResources();
            if (this.status == 0) {
                if (this.resourceCount == 0) {
                    this.status = 3;
                } else if (this.resourceCount == 1) {
                    this.commitResources(true);
                } else if (!this.prepareResources()) {
                    boolean commitDecision;
                    boolean bl = commitDecision = this.status == 2 && (this.heuristicCode == 4 || this.heuristicCode == 7);
                    if (commitDecision) {
                        this.commitResources(false);
                    }
                } else {
                    this.status = 3;
                }
            }
            if (this.status != 3) {
                this.rollbackResources();
                this.doAfterCompletion();
                this.cancelTimeout();
                this.instanceDone();
                throw new RollbackException("Unable to commit, tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
            }
            this.cancelTimeout();
            this.doAfterCompletion();
            this.instanceDone();
            this.checkHeuristics();
        }
        finally {
            Object var2_2 = null;
            this.unlock();
            if (this.done) {
                TxCapsule.releaseInstance(this);
            }
        }
    }

    private void commitResources(boolean onePhase) {
        this.status = 8;
        int i = 0;
        while (i < this.resourceCount) {
            if ((onePhase || this.resourceState[i] == 5) && this.resourceSameRM[i] == -1) {
                if (this.status != 8) {
                    return;
                }
                try {
                    this.unlock();
                    try {
                        this.resources[i].commit(this.resourceXids[i], onePhase);
                    }
                    finally {
                        Object var4_7 = null;
                        this.lock();
                    }
                }
                catch (XAException e) {
                    switch (e.errorCode) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            this.gotHeuristic(i, e.errorCode);
                            break;
                        }
                        default: {
                            String msg = "XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(e.errorCode);
                            log.warn(msg, e);
                        }
                    }
                    try {
                        this.resources[i].forget(this.resourceXids[i]);
                    }
                    catch (XAException xAException) {}
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.status == 8) {
            this.status = 3;
        }
    }

    private Xid createXidBranch() {
        int branchId = ++this.lastBranchId;
        if (xidConstructor == null) {
            return new XidImpl(this.xid, branchId);
        }
        try {
            if (this.xidConstructorArgs[1] == null) {
                byte[] gidShort = this.xid.getGlobalTransactionId();
                byte[] gid = new byte[64];
                System.arraycopy(gidShort, 0, gid, 0, gidShort.length);
                this.xidConstructorArgs[1] = gid;
            }
            byte[] bqidShort = Integer.toString(branchId).getBytes();
            byte[] bqid = new byte[64];
            System.arraycopy(bqidShort, 0, bqid, 0, bqidShort.length);
            this.xidConstructorArgs[2] = bqid;
            return (Xid)xidConstructor.newInstance(this.xidConstructorArgs);
        }
        catch (Exception e) {
            System.out.println("Unable to create an Xid (reverting to default impl): " + e);
            return new XidImpl(this.xid, branchId);
        }
    }

    boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes");
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new IllegalArgumentException("Bad flag: " + flag);
        }
        try {
            this.lock();
            int idx = this.findResource(xaRes);
            if (idx == -1) {
                throw new IllegalArgumentException("xaRes not enlisted");
            }
            switch (this.status) {
                case 7: {
                    throw new IllegalStateException("Already started preparing.");
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back.");
                }
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
                case 0: 
                case 1: 
            }
            try {
                this.endResource(idx, flag);
                boolean bl = true;
                Object var5_6 = null;
                this.unlock();
                return bl;
            }
            catch (XAException e) {
                String msg = "XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(e.errorCode);
                log.warn(msg, e);
                this.status = 1;
                boolean bl = false;
                Object var5_7 = null;
                this.unlock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.unlock();
            throw throwable;
        }
    }

    private void doAfterCompletion() {
        this.unlock();
        try {
            int i = 0;
            while (i < this.syncCount) {
                try {
                    this.sync[i].afterCompletion(this.status);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ++i;
            }
        }
        finally {
            Object var2_3 = null;
            this.lock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBeforeCompletion() {
        this.unlock();
        try {
            int i = 0;
            while (i < this.syncCount) {
                try {
                    this.sync[i].beforeCompletion();
                }
                catch (Throwable t) {
                    this.status = 1;
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.lock();
            throw throwable;
        }
        Object var2_3 = null;
        this.lock();
    }

    private void endResource(int idx, int flag) throws XAException {
        block7: {
            this.unlock();
            try {
                try {
                    this.resources[idx].end(this.resourceXids[idx], flag);
                }
                catch (XAException e) {
                    throw e;
                }
                catch (Throwable t) {
                    this.status = 1;
                    this.resourceState[idx] = 3;
                    Object var4_5 = null;
                    this.lock();
                    return;
                }
                if (flag == 0x2000000) {
                    this.resourceState[idx] = 2;
                    break block7;
                }
                if (flag == 0x20000000) {
                    this.status = 1;
                }
                this.resourceState[idx] = 3;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.lock();
                throw throwable;
            }
        }
        Object var4_6 = null;
        this.lock();
    }

    private void endResources() {
        int idx = 0;
        while (idx < this.resourceCount) {
            try {
                if (this.resourceState[idx] == 2) {
                    this.startResource(idx);
                }
                if (this.resourceState[idx] == 1) {
                    this.endResource(idx, 0x4000000);
                }
            }
            catch (XAException e) {
                String msg = "XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(e.errorCode);
                log.warn(msg, e);
                this.status = 1;
            }
            ++idx;
        }
        this.resourcesEnded = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        boolean bl;
        block24: {
            boolean bl2;
            block23: {
                boolean bl3;
                block22: {
                    if (xaRes == null) {
                        throw new IllegalArgumentException("null xaRes");
                    }
                    try {
                        this.lock();
                        switch (this.status) {
                            case 2: {
                                throw new IllegalStateException("Already prepared.");
                            }
                            case 8: {
                                throw new IllegalStateException("Already started committing.");
                            }
                            case 3: {
                                throw new IllegalStateException("Already committed.");
                            }
                            case 1: {
                                throw new RollbackException("Already marked for rollback");
                            }
                            case 9: {
                                throw new RollbackException("Already started rolling back.");
                            }
                            case 4: {
                                throw new RollbackException("Already rolled back.");
                            }
                            case 6: {
                                throw new IllegalStateException("No transaction.");
                            }
                            case 5: {
                                throw new IllegalStateException("Unknown state");
                            }
                            default: {
                                throw new IllegalStateException("Illegal status: " + this.status);
                            }
                            case 0: 
                            case 7: 
                        }
                        if (this.resourcesEnded) {
                            throw new IllegalStateException("Too late to enlist resources");
                        }
                        try {
                            int idx = this.findResource(xaRes);
                            if (idx != -1) {
                                if (this.resourceState[idx] == 1) {
                                    boolean bl4 = false;
                                    Object var4_9 = null;
                                    this.unlock();
                                    return bl4;
                                }
                                this.startResource(idx);
                                bl3 = true;
                                break block22;
                            }
                            if (xidConstructor == null) {
                                int i = 0;
                                while (i < this.resourceCount) {
                                    if (this.resourceSameRM[i] == -1 && xaRes.isSameRM(this.resources[i])) {
                                        this.startResource(this.addResource(xaRes, this.resourceXids[i], i));
                                        bl2 = true;
                                        break block23;
                                    }
                                    ++i;
                                }
                            }
                            this.startResource(this.addResource(xaRes, this.createXidBranch(), -1));
                            bl = true;
                            break block24;
                        }
                        catch (XAException e) {
                            String msg = "XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(e.errorCode);
                            log.warn(msg, e);
                            boolean bl5 = false;
                            Object var4_13 = null;
                            this.unlock();
                            return bl5;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_14 = null;
                        this.unlock();
                        throw throwable;
                    }
                }
                Object var4_10 = null;
                this.unlock();
                return bl3;
            }
            Object var4_11 = null;
            this.unlock();
            return bl2;
        }
        Object var4_12 = null;
        this.unlock();
        return bl;
    }

    private int findResource(XAResource xaRes) {
        int idx = 0;
        while (idx < this.resourceCount) {
            if (xaRes == this.resources[idx]) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    static TxCapsule getInstance(long timeOut) {
        TxCapsule txCapsule = null;
        LinkedList linkedList = inactiveCapsules;
        synchronized (linkedList) {
            while (inactiveCapsules.size() > 0) {
                SoftReference ref = (SoftReference)inactiveCapsules.removeFirst();
                txCapsule = (TxCapsule)ref.get();
                if (txCapsule != null) break;
            }
        }
        if (txCapsule == null) {
            txCapsule = new TxCapsule(timeOut);
        } else {
            super.reUse(timeOut);
        }
        return txCapsule;
    }

    int getStatus() throws SystemException {
        return this.status;
    }

    private String getStringStatus(int status) {
        switch (status) {
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 0: {
                return "STATUS_ACTIVE";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    private String getStringXAErrorCode(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }

    TransactionImpl getTransactionImpl() {
        return this.transaction;
    }

    private void gotHeuristic(int resIdx, int code) {
        switch (code) {
            case 5: {
                this.heuristicCode = 5;
                break;
            }
            case 6: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 6;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 7: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 7;
                    break;
                }
                if (this.heuristicCode != 6 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 8: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 8;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 6) break;
                this.heuristicCode = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (resIdx != -1) {
            try {
                try {
                    this.unlock();
                    this.resources[resIdx].forget(this.resourceXids[resIdx]);
                }
                catch (XAException e) {
                    String msg = "XAException at forget(): errorCode=" + this.getStringXAErrorCode(e.errorCode);
                    log.warn(msg, e);
                }
                Object var4_5 = null;
                this.lock();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.lock();
                throw throwable;
            }
        }
    }

    private void instanceDone() {
        this.transaction.setDone();
        TxCapsule txCapsule = this;
        synchronized (txCapsule) {
            ++this.incarnationCount;
            this.done = true;
            this.notifyAll();
        }
        int i = 0;
        while (i < this.syncCount) {
            this.sync[i] = null;
            ++i;
        }
        this.syncCount = 0;
        this.transaction = null;
        int i2 = 0;
        while (i2 < this.resourceCount) {
            this.resources[i2] = null;
            this.resourceXids[i2] = null;
            ++i2;
        }
        this.resourceCount = 0;
        if (xidConstructor != null) {
            this.xidConstructorArgs[1] = null;
        }
    }

    private synchronized void lock() {
        if (this.done) {
            throw new IllegalStateException("Transaction has terminated");
        }
        if (this.locked) {
            log.warn("TxCapsule: Lock contention, tx=" + this.toString());
            long myIncarnation = this.incarnationCount;
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                if (!this.done && myIncarnation == this.incarnationCount) continue;
                throw new IllegalStateException("Transaction has now terminated");
            }
        }
        this.locked = true;
    }

    private boolean prepareResources() {
        boolean readOnly = true;
        this.status = 7;
        int i = 0;
        while (i < this.resourceCount) {
            block19: {
                if (this.status != 7) {
                    return false;
                }
                if (this.resourceSameRM[i] == -1) {
                    XAResource resource = this.resources[i];
                    try {
                        int vote;
                        this.unlock();
                        try {
                            vote = this.resources[i].prepare(this.resourceXids[i]);
                        }
                        finally {
                            Object var6_9 = null;
                            this.lock();
                        }
                        if (vote == 0) {
                            readOnly = false;
                            this.resourceState[i] = 5;
                            break block19;
                        }
                        if (vote == 3) {
                            this.resourceState[i] = 4;
                            break block19;
                        }
                        this.status = 1;
                        return false;
                    }
                    catch (XAException e) {
                        readOnly = false;
                        switch (e.errorCode) {
                            case 7: {
                                this.gotHeuristic(i, e.errorCode);
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 8: {
                                this.gotHeuristic(i, e.errorCode);
                                if (this.status == 7) {
                                    this.status = 1;
                                    break;
                                }
                            }
                            default: {
                                String msg = "XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(e.errorCode);
                                log.warn(msg, e);
                                if (this.status == 7) {
                                    this.status = 1;
                                    break;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (this.status != 7) break block19;
                        this.status = 1;
                    }
                }
            }
            ++i;
        }
        if (this.status == 7) {
            this.status = 2;
        }
        return readOnly;
    }

    private void reUse(long timeout) {
        if (!this.done) {
            throw new IllegalStateException();
        }
        this.done = false;
        this.resourcesEnded = false;
        this.xid = new XidImpl();
        this.lastBranchId = 0;
        this.transaction = new TransactionImpl(this, this.xid);
        this.status = 0;
        this.heuristicCode = 4;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout(this.start + timeout, this);
    }

    void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException, SystemException {
        if (s == null) {
            throw new IllegalArgumentException("Null synchronization");
        }
        try {
            this.lock();
            switch (this.status) {
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 1: {
                    throw new RollbackException("Already marked for rollback");
                }
                case 9: {
                    throw new RollbackException("Already started rolling back.");
                }
                case 4: {
                    throw new RollbackException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
                case 0: 
                case 7: 
            }
            if (this.syncCount == this.syncAllocSize) {
                this.syncAllocSize = 2 * this.syncAllocSize;
                Synchronization[] sy = new Synchronization[this.syncAllocSize];
                System.arraycopy(this.sync, 0, sy, 0, this.syncCount);
                this.sync = sy;
            }
            this.sync[this.syncCount++] = s;
        }
        finally {
            Object var3_3 = null;
            this.unlock();
        }
    }

    private static void releaseInstance(TxCapsule txCapsule) {
        LinkedList linkedList = inactiveCapsules;
        synchronized (linkedList) {
            inactiveCapsules.add(new SoftReference<TxCapsule>(txCapsule));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void rollback() throws IllegalStateException, SecurityException, SystemException {
        block7: {
            try {
                this.lock();
                switch (this.status) {
                    case 0: 
                    case 1: {
                        this.doBeforeCompletion();
                        this.endResources();
                        this.rollbackResources();
                        this.cancelTimeout();
                        this.doAfterCompletion();
                        this.instanceDone();
                        this.heuristicCode = 4;
                        Object var2_1 = null;
                        this.unlock();
                        if (!this.done) return;
                        break;
                    }
                    case 7: {
                        this.status = 1;
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException("Cannot rollback(), tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.unlock();
                if (!this.done) throw throwable;
                TxCapsule.releaseInstance(this);
                throw throwable;
            }
            TxCapsule.releaseInstance(this);
            return;
        }
        Object var2_2 = null;
        this.unlock();
        if (!this.done) return;
        TxCapsule.releaseInstance(this);
    }

    private void rollbackResources() {
        this.status = 9;
        int i = 0;
        while (i < this.resourceCount) {
            if (this.resourceState[i] != 4) {
                try {
                    this.unlock();
                    try {
                        this.resources[i].rollback(this.resourceXids[i]);
                    }
                    finally {
                        Object var3_6 = null;
                        this.lock();
                    }
                }
                catch (XAException e) {
                    switch (e.errorCode) {
                        case 6: {
                            this.gotHeuristic(i, e.errorCode);
                            break;
                        }
                        case 5: 
                        case 7: 
                        case 8: {
                            this.gotHeuristic(i, e.errorCode);
                            break;
                        }
                        default: {
                            String msg = "XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(e.errorCode);
                            log.warn(msg, e);
                        }
                    }
                    try {
                        this.resources[i].forget(this.resourceXids[i]);
                    }
                    catch (XAException xAException) {}
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.status = 4;
    }

    void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.lock();
            switch (this.status) {
                case 0: 
                case 2: 
                case 7: {
                    this.status = 1;
                }
                case 1: 
                case 9: {
                    Object var2_1 = null;
                    this.unlock();
                    return;
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
            }
            throw new IllegalStateException("Illegal status: " + this.status);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
    }

    private void startResource(int idx) throws XAException {
        int flags = 0x200000;
        if (this.resourceSameRM[idx] == -1) {
            switch (this.resourceState[idx]) {
                case 0: {
                    flags = 0;
                    break;
                }
                case 2: {
                    flags = 0x8000000;
                    break;
                }
            }
        }
        this.unlock();
        try {
            try {
                this.resources[idx].start(this.resourceXids[idx], flags);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                this.status = 1;
                Object var4_5 = null;
                this.lock();
                return;
            }
            this.resourceState[idx] = 1;
        }
        finally {
            Object var4_6 = null;
            this.lock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void timedOut(Timeout timeout) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                try {
                                    this.lock();
                                    log.warn("Transaction " + this.toString() + " timed out." + " status=" + this.getStringStatus(this.status));
                                    if (this.timeout == null) {
                                        Object var3_2 = null;
                                        this.unlock();
                                        return;
                                    }
                                    this.timeout = null;
                                    switch (this.status) {
                                        case 3: 
                                        case 4: 
                                        case 6: {
                                            break block11;
                                        }
                                        case 9: {
                                            break block12;
                                        }
                                        case 8: {
                                            this.gotHeuristic(-1, 5);
                                            this.status = 1;
                                            break block13;
                                        }
                                        case 0: 
                                        case 2: {
                                            this.status = 1;
                                        }
                                        case 1: {
                                            break block14;
                                        }
                                        case 7: {
                                            this.status = 1;
                                            break block15;
                                        }
                                        default: {
                                            log.warn("TxCapsule: Unknown status at timeout, tx=" + this.toString());
                                            break;
                                        }
                                    }
                                    break block16;
                                }
                                catch (Throwable throwable) {
                                    Object var3_9 = null;
                                    this.unlock();
                                    throw throwable;
                                }
                            }
                            Object var3_3 = null;
                            this.unlock();
                            return;
                        }
                        Object var3_4 = null;
                        this.unlock();
                        return;
                    }
                    Object var3_5 = null;
                    this.unlock();
                    return;
                }
                Object var3_6 = null;
                this.unlock();
                return;
            }
            Object var3_7 = null;
            this.unlock();
            return;
        }
        Object var3_8 = null;
        this.unlock();
    }

    public String toString() {
        return XidImpl.toString(this.xid);
    }

    private synchronized void unlock() {
        if (!this.locked) {
            String msg = "TxCapsule: Unlocking, but not locked, tx=" + this.toString();
            log.warn(msg, new Exception("[Stack trace]"));
        }
        this.locked = false;
        this.notify();
    }
}

