/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.server;

import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.tm.usertx.client.ClientUserTransaction;
import org.jboss.tm.usertx.interfaces.UserTransactionSessionFactory;
import org.jboss.tm.usertx.server.ClientUserTransactionServiceMBean;
import org.jboss.tm.usertx.server.UserTransactionSessionFactoryImpl;
import org.jboss.util.ServiceMBeanSupport;

public class ClientUserTransactionService
extends ServiceMBeanSupport
implements ClientUserTransactionServiceMBean {
    public static String JNDI_NAME = "UserTransaction";
    public static String FACTORY_NAME = "UserTransactionSessionFactory";
    MBeanServer server;
    private UserTransactionSessionFactory factory;

    public String getName() {
        return "Client UserTransaction manager";
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return new ObjectName(":service=ClientUserTransaction");
    }

    protected void startService() throws Exception {
        this.factory = new UserTransactionSessionFactoryImpl();
        InitialContext ctx = new InitialContext();
        ctx.bind(FACTORY_NAME, (Object)this.factory);
        ctx.bind(JNDI_NAME, (Object)ClientUserTransaction.getSingleton());
    }

    protected void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(FACTORY_NAME);
            ctx.unbind(JNDI_NAME);
            try {
                UnicastRemoteObject.unexportObject(this.factory, true);
            }
            catch (Exception ex) {
                this.log.error("unexportObject failure", ex);
            }
            this.factory = null;
        }
        catch (Exception e) {
            this.log.error("stopService failure", e);
        }
    }
}

