/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.usertx.interfaces.UserTransactionSession;

public class UserTransactionSessionImpl
extends UnicastRemoteObject
implements UserTransactionSession,
Unreferenced {
    private static TransactionManager tm = null;
    private static Logger log = Logger.getLogger(class$org$jboss$tm$usertx$server$UserTransactionSessionImpl != null ? class$org$jboss$tm$usertx$server$UserTransactionSessionImpl : (class$org$jboss$tm$usertx$server$UserTransactionSessionImpl = UserTransactionSessionImpl.class$("org.jboss.tm.usertx.server.UserTransactionSessionImpl")));
    private static TransactionPropagationContextFactory tpcFactory = null;
    private Map activeTx = new HashMap();
    static /* synthetic */ Class class$org$jboss$tm$usertx$server$UserTransactionSessionImpl;

    public Object begin(int timeout) throws RemoteException, NotSupportedException, SystemException {
        TransactionManager tm = UserTransactionSessionImpl.getTransactionManager();
        tm.setTransactionTimeout(timeout);
        tm.begin();
        Object tpc = UserTransactionSessionImpl.getTPCFactory().getTransactionPropagationContext();
        Transaction tx = tm.suspend();
        this.activeTx.put(tpc, tx);
        return tpc;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit(Object tpc) throws RemoteException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = (Transaction)this.activeTx.get(tpc);
        if (tx == null) {
            throw new IllegalStateException("No transaction.");
        }
        TransactionManager tm = UserTransactionSessionImpl.getTransactionManager();
        Transaction currentTx = tm.suspend();
        tm.resume(tx);
        boolean finished = true;
        try {
            try {
                tx.commit();
            }
            catch (SecurityException ex) {
                finished = false;
                throw ex;
            }
            catch (IllegalStateException ex) {
                finished = false;
                throw ex;
            }
            Object var7_8 = null;
            this.activeTx.remove(tpc);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.activeTx.remove(tpc);
            tm.suspend();
            if (currentTx != null) {
                tm.resume(currentTx);
            }
            throw throwable;
        }
        tm.suspend();
        if (currentTx != null) {
            tm.resume(currentTx);
        }
    }

    public void destroy() throws RemoteException {
        UnicastRemoteObject.unexportObject(this, true);
        this.unreferenced();
    }

    public int getStatus(Object tpc) throws RemoteException, SystemException {
        Transaction tx = (Transaction)this.activeTx.get(tpc);
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    protected static TransactionPropagationContextFactory getTPCFactory() {
        block2: {
            if (tpcFactory != null) break block2;
            try {
                InitialContext ctx = new InitialContext();
                tpcFactory = (TransactionPropagationContextFactory)ctx.lookup("java:/TransactionPropagationContextExporter");
            }
            catch (NamingException ex) {
                log.error("TransactionPropagationContextExporter lookup failure", ex);
            }
        }
        return tpcFactory;
    }

    protected static TransactionManager getTransactionManager() {
        block2: {
            if (tm != null) break block2;
            try {
                InitialContext ctx = new InitialContext();
                tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            }
            catch (NamingException ex) {
                log.error("TransactionManager lookup failure", ex);
            }
        }
        return tm;
    }

    public void rollback(Object tpc) throws RemoteException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = (Transaction)this.activeTx.get(tpc);
        if (tx == null) {
            throw new IllegalStateException("No transaction.");
        }
        TransactionManager tm = UserTransactionSessionImpl.getTransactionManager();
        Transaction currentTx = tm.suspend();
        tm.resume(tx);
        tx.rollback();
        this.activeTx.remove(tpc);
        tm.suspend();
        if (currentTx != null) {
            tm.resume(currentTx);
        }
    }

    public void setRollbackOnly(Object tpc) throws RemoteException, IllegalStateException, SystemException {
        Transaction tx = (Transaction)this.activeTx.get(tpc);
        if (tx == null) {
            throw new IllegalStateException("No transaction.");
        }
        tx.setRollbackOnly();
    }

    public void unreferenced() {
        log.debug("Lost connection to UserTransaction client.");
        if (!this.activeTx.isEmpty()) {
            log.error("Lost connection to UserTransaction clients: Rolling back " + this.activeTx.size() + " active transaction(s).");
            Collection txs = this.activeTx.values();
            Iterator iter = txs.iterator();
            while (iter.hasNext()) {
                Transaction tx = (Transaction)iter.next();
                try {
                    tx.rollback();
                }
                catch (Exception ex) {
                    log.error("rollback failure", ex);
                }
            }
        }
    }
}

