/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.util.CounterServiceMBean;
import org.jboss.util.ServiceMBeanSupport;

public class CounterService
extends ServiceMBeanSupport
implements CounterServiceMBean {
    private HashMap counterMap = new HashMap();
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public void accumulate(String counterName, long add) {
        Counter counter = null;
        HashMap hashMap = this.counterMap;
        synchronized (hashMap) {
            counter = (Counter)this.counterMap.get(counterName);
            if (counter == null) {
                counter = new Counter(counterName);
                this.counterMap.put(counterName, counter);
            }
        }
        counter.addToCount(add);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getName() {
        return "Counter Service";
    }

    public String list() {
        DecimalFormat format = new DecimalFormat("####0.0000");
        String retVal = "";
        Iterator keys = this.counterMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Counter counter = (Counter)this.counterMap.get(key);
            long total = 0L;
            int entries = 0;
            Counter counter2 = counter;
            synchronized (counter2) {
                total = counter.getCount();
                entries = counter.getEntries();
            }
            double avg = (double)total / (double)entries;
            String descrip = String.valueOf(key) + ": total=" + total + " on " + entries + "entries for " + "an average of " + format.format(avg) + "<br>\n";
            retVal = String.valueOf(retVal) + descrip;
        }
        return retVal;
    }

    protected void startService() throws Exception {
        super.startService();
        InitialContext ctx = new InitialContext();
        NonSerializableFactory.bind("java:/CounterService", this);
        StringRefAddr addr = new StringRefAddr("nns", "java:/CounterService");
        Reference ref = new Reference(this.getClass().getName(), addr, (class$org$jboss$naming$NonSerializableFactory != null ? class$org$jboss$naming$NonSerializableFactory : (class$org$jboss$naming$NonSerializableFactory = CounterService.class$("org.jboss.naming.NonSerializableFactory"))).getName(), null);
        ctx.bind("java:/CounterService", (Object)ref);
    }

    protected void stopService() throws Exception {
        super.stopService();
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind("java:/CounterService");
            NonSerializableFactory.unbind("java:/CounterService");
        }
        catch (NamingException ne) {
            this.log.error("Coulnd't unbind CounterService: " + ne.getMessage());
        }
    }

    private static class Counter {
        private String name;
        private long count = 0L;
        private int entries = 0;

        public Counter(String n) {
            this.name = n;
        }

        public synchronized void addToCount(long add) {
            this.count += add;
            ++this.entries;
        }

        public synchronized long getCount() {
            return this.count;
        }

        public synchronized int getEntries() {
            return this.entries;
        }

        public String getName() {
            return this.name;
        }
    }
}

