/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jboss.util.MIME2Java;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static String PRINTWRITER_ENCODING = "UTF8";
    private static String[] MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};
    protected PrintWriter out;
    protected boolean canonical;

    public DOMWriter(Writer w, boolean canonical) throws UnsupportedEncodingException {
        this.out = new PrintWriter(w);
        this.canonical = canonical;
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public void print(Node node) {
        this.print(node, true);
    }

    public void print(Node node, boolean prettyprint) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    String Encoding = DOMWriter.getWriterEncoding();
                    Encoding = Encoding.equalsIgnoreCase("DEFAULT") ? "UTF-8" : (Encoding.equalsIgnoreCase("Unicode") ? "UTF-16" : MIME2Java.reverse(Encoding));
                    this.out.println("<?xml version=\"1.0\" encoding=\"" + Encoding + "\"?>");
                }
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.print(children.item(iChild));
                    ++iChild;
                }
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                    ++i;
                }
                this.out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.print(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(children.item(i));
                        ++i;
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.println("?>");
                break;
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
            if (prettyprint) {
                this.out.println();
            }
        }
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }
}

