/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.jboss.util.FileURLPatchMBean;
import sun.net.www.protocol.file.Handler;

public class FileURLPatch
implements FileURLPatchMBean,
MBeanRegistration {
    public static final String OBJECT_NAME = ":service=FileURLPatch";
    Category log = Category.getInstance((Class)(class$org$jboss$util$FileURLPatch != null ? class$org$jboss$util$FileURLPatch : (class$org$jboss$util$FileURLPatch = FileURLPatch.class$("org.jboss.util.FileURLPatch"))));
    private CustomURLStreamHandlerFactory customURLStreamHandlerFactory = new CustomURLStreamHandlerFactory();
    private boolean enabled = false;
    private FileHandler fileHander = new FileHandler();
    static /* synthetic */ Class class$org$jboss$util$FileURLPatch;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        URL.setURLStreamHandlerFactory(this.customURLStreamHandlerFactory);
        return new ObjectName(OBJECT_NAME);
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (this.enabled) {
            this.log.info((Object)"The file URL patch has been enabled.");
        } else {
            this.log.info((Object)"The file URL patch has been disabled.");
        }
    }

    private class CustomURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        CustomURLStreamHandlerFactory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("file")) {
                return FileURLPatch.this.fileHander;
            }
            return null;
        }
    }

    private class FileHandler
    extends Handler {
        FileHandler() {
        }

        protected void parseURL(URL u, String spec, int start, int limit) {
            super.parseURL(u, spec, start, limit);
            if (FileURLPatch.this.enabled) {
                this.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), u.getFile().replace('+', ' '), u.getRef());
            }
        }

        protected String toExternalForm(URL u) {
            if (FileURLPatch.this.enabled) {
                String s = super.toExternalForm(u);
                return s.replace(' ', '+');
            }
            return super.toExternalForm(u);
        }
    }
}

