/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.Executable;

public class WorkerQueue {
    protected Thread m_queueThread;
    private JobItem m_currentJob;

    public WorkerQueue() {
        this("Worker Thread");
    }

    public WorkerQueue(String threadName) {
        this.m_queueThread = new Thread(this.createQueueLoop(), threadName);
    }

    public WorkerQueue(String threadName, boolean isDaemon) {
        this.m_queueThread = new Thread(this.createQueueLoop(), threadName);
        this.m_queueThread.setDaemon(isDaemon);
    }

    protected void clear() {
        this.m_queueThread = null;
        this.m_currentJob = null;
    }

    protected Runnable createQueueLoop() {
        return new QueueLoop();
    }

    protected synchronized Executable getJob() throws InterruptedException {
        if (this.m_queueThread == null || !this.m_queueThread.isAlive()) {
            throw new IllegalStateException();
        }
        return this.getJobImpl();
    }

    protected Executable getJobImpl() throws InterruptedException {
        while (this.m_currentJob == null) {
            this.wait();
        }
        JobItem item = this.m_currentJob;
        this.m_currentJob = this.m_currentJob.m_next;
        return item.m_job;
    }

    protected boolean isInterrupted() {
        return this.m_queueThread.isInterrupted();
    }

    protected void logJobException(Exception x) {
        x.printStackTrace();
    }

    public synchronized void putJob(Executable job) {
        if (this.m_queueThread == null || !this.m_queueThread.isAlive()) {
            throw new IllegalStateException("Can't put job, thread is not alive or not present");
        }
        if (this.isInterrupted()) {
            throw new IllegalStateException("Can't put job, thread was interrupted");
        }
        this.putJobImpl(job);
    }

    protected void putJobImpl(Executable job) {
        class Org_jboss_util_WorkerQueue$1 {
            /* synthetic */ Org_jboss_util_WorkerQueue$1() {
            }
        }
        JobItem posted = new JobItem(null, job);
        if (this.m_currentJob == null) {
            this.m_currentJob = posted;
            this.notifyAll();
        } else {
            JobItem item = this.m_currentJob;
            while (item.m_next != null) {
                item = item.m_next;
            }
            item.m_next = posted;
        }
    }

    public void start() {
        if (this.m_queueThread != null) {
            this.m_queueThread.start();
        }
    }

    public synchronized void stop() {
        if (this.m_queueThread != null) {
            this.m_queueThread.interrupt();
        }
    }

    protected class QueueLoop
    implements Runnable {
        protected QueueLoop() {
        }

        protected void flush() throws Exception {
            while (WorkerQueue.this.m_currentJob != null) {
                WorkerQueue.this.m_currentJob.m_job.execute();
                WorkerQueue.this.m_currentJob = WorkerQueue.this.m_currentJob.m_next;
            }
        }

        public void run() {
            try {
                block7: while (true) {
                    try {
                        while (true) {
                            if (WorkerQueue.this.isInterrupted()) {
                                this.flush();
                                break block7;
                            }
                            WorkerQueue.this.getJob().execute();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            this.flush();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception x) {
                        WorkerQueue.this.logJobException(x);
                        continue;
                    }
                    break;
                }
                Object var2_2 = null;
                WorkerQueue.this.clear();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                WorkerQueue.this.clear();
                throw throwable;
            }
        }
    }

    private class JobItem {
        private Executable m_job;
        private JobItem m_next;

        private JobItem(Executable job) {
            this.m_job = job;
        }

        /* synthetic */ JobItem(1 $0, Executable $1) {
            this($1);
        }
    }
}

