/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.naming.Util;
import org.jboss.security.plugins.NullSecurityManager;
import org.jboss.util.ServiceMBeanSupport;
import org.jboss.web.AbstractWebContainerMBean;
import org.jboss.web.WebApplication;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractWebContainer
extends ServiceMBeanSupport
implements AbstractWebContainerMBean {
    protected HashMap deploymentMap = new HashMap();

    protected void addEnvEntries(Iterator envEntries, Context envCtx) throws ClassNotFoundException, NamingException {
        while (envEntries.hasNext()) {
            EnvEntryMetaData entry = (EnvEntryMetaData)envEntries.next();
            this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
            EnvEntryMetaData.bindEnvEntry(envCtx, entry);
        }
    }

    public synchronized void deploy(String ctxPath, String warUrl) throws DeploymentException {
        Thread thread = Thread.currentThread();
        ClassLoader appClassLoader = thread.getContextClassLoader();
        try {
            try {
                URL[] empty = new URL[]{};
                URLClassLoader warLoader = URLClassLoader.newInstance(empty, appClassLoader);
                thread.setContextClassLoader(warLoader);
                DescriptorParser webAppParser = new DescriptorParser();
                WebMetaData metaData = this.parseMetaData(ctxPath, warUrl);
                WebApplication warInfo = new WebApplication(metaData);
                this.performDeploy(warInfo, warUrl, webAppParser);
                this.deploymentMap.put(warUrl, warInfo);
            }
            catch (DeploymentException e) {
                throw (DeploymentException)e.fillInStackTrace();
            }
            catch (Exception e) {
                this.log.error("Cause", e);
                throw new DeploymentException("Error during deploy", e);
            }
            Object var6_12 = null;
            thread.setContextClassLoader(appClassLoader);
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            thread.setContextClassLoader(appClassLoader);
            throw throwable;
        }
    }

    private URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Object[] args;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getURLs = cl.getClass().getMethod("getAllURLs", parameterTypes)).getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {}
        return urls;
    }

    public String[] getCompileClasspath(ClassLoader loader) {
        HashSet<String> tmp = new HashSet<String>();
        ClassLoader cl = loader;
        while (cl != null) {
            URL[] urls = this.getClassLoaderURLs(cl);
            int u = 0;
            while (u < urls.length) {
                URL url = urls[u];
                tmp.add(url.toExternalForm());
                ++u;
            }
            cl = cl.getParent();
        }
        this.log.trace("JSP CompileClasspath: " + tmp);
        String[] cp = new String[tmp.size()];
        ((AbstractCollection)tmp).toArray(cp);
        return cp;
    }

    public Element getConfig() {
        return null;
    }

    public WebApplication getDeployedApp(String warUrl) {
        WebApplication appInfo = (WebApplication)this.deploymentMap.get(warUrl);
        return appInfo;
    }

    public Iterator getDeployedApplications() {
        return this.deploymentMap.values().iterator();
    }

    public boolean isDeployed(String warUrl) {
        return this.deploymentMap.containsKey(warUrl);
    }

    protected void linkEjbLocalRefs(Iterator ejbRefs, Context envCtx) throws NamingException {
        InitialContext iniCtx = new InitialContext();
        while (ejbRefs.hasNext()) {
            EjbLocalRefMetaData ejb = (EjbLocalRefMetaData)ejbRefs.next();
            String name = ejb.getName();
            String jndiName = ejb.getLink();
            if (jndiName == null) {
                throw new NamingException("ejb-local-ref: " + name + ", target not found, add valid ejb-link");
            }
            try {
                Object ref = iniCtx.lookup(jndiName);
                if (!(ref instanceof EJBLocalHome)) {
                    jndiName = "local/" + jndiName;
                }
            }
            catch (NamingException namingException) {}
            this.log.debug("Linking ejb-local-ref: " + name + " to JNDI name: " + jndiName);
            Util.bind(envCtx, name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbRefs(Iterator ejbRefs, Context envCtx) throws NamingException {
        while (ejbRefs.hasNext()) {
            EjbRefMetaData ejb = (EjbRefMetaData)ejbRefs.next();
            String name = ejb.getName();
            String jndiName = ejb.getJndiName();
            String linkName = ejb.getLink();
            if (jndiName == null) {
                jndiName = linkName;
            }
            this.log.debug("Linking ejb-ref: " + name + " to JNDI name: " + jndiName);
            if (jndiName == null) {
                throw new NamingException("ejb-ref: " + name + ", expected jndi-name in jboss-web.xml");
            }
            Util.bind(envCtx, name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkResourceEnvRefs(Iterator resourceEnvRefs, Context envCtx) throws NamingException {
        while (resourceEnvRefs.hasNext()) {
            ResourceEnvRefMetaData ref = (ResourceEnvRefMetaData)resourceEnvRefs.next();
            String resourceName = ref.getJndiName();
            String refName = ref.getRefName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    this.log.debug("Binding '" + refName + "' to URL: " + resourceName);
                    URL url = new URL(resourceName);
                    Util.bind(envCtx, refName, (Object)url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            this.log.debug("Linking '" + refName + "' to JNDI name: " + resourceName);
            Util.bind(envCtx, refName, (Object)new LinkRef(resourceName));
        }
    }

    protected void linkResourceRefs(Iterator resourceRefs, Context envCtx) throws NamingException {
        while (resourceRefs.hasNext()) {
            ResourceRefMetaData ref = (ResourceRefMetaData)resourceRefs.next();
            String jndiName = ref.getJndiName();
            String refName = ref.getRefName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    this.log.debug("Binding '" + refName + "' to URL: " + jndiName);
                    URL url = new URL(jndiName);
                    Util.bind(envCtx, refName, (Object)url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            this.log.debug("Linking '" + refName + "' to JNDI name: " + jndiName);
            Util.bind(envCtx, refName, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkSecurityDomain(String securityDomain, Context envCtx) throws NamingException {
        if (securityDomain == null) {
            this.log.debug("Binding security/securityMgr to NullSecurityManager");
            NullSecurityManager securityMgr = new NullSecurityManager("java:/jaas/null");
            Util.bind(envCtx, "security/securityMgr", (Object)securityMgr);
            Util.bind(envCtx, "security/realmMapping", (Object)securityMgr);
            Util.bind(envCtx, "security/security-domain", (Object)new LinkRef("java:/jaas/null"));
            Util.bind(envCtx, "security/subject", (Object)new LinkRef("java:/jaas/null/subject"));
        } else {
            this.log.debug("Linking security/securityMgr to JNDI name: " + securityDomain);
            Util.bind(envCtx, "security/securityMgr", (Object)new LinkRef(securityDomain));
            Util.bind(envCtx, "security/realmMapping", (Object)new LinkRef(securityDomain));
            Util.bind(envCtx, "security/security-domain", (Object)new LinkRef(securityDomain));
            Util.bind(envCtx, "security/subject", (Object)new LinkRef(String.valueOf(securityDomain) + "/subject"));
        }
    }

    protected WebMetaData parseMetaData(String ctxPath, String warUrl) throws MalformedURLException {
        String webContext;
        String defaultWebContext;
        WebMetaData metaData = new WebMetaData();
        URL warURL = new URL(warUrl);
        InputStream jbossWebIS = null;
        InputStream webIS = null;
        try {
            File warDir = new File(warURL.getFile());
            if (warURL.getProtocol().equals("file") && warDir.isDirectory()) {
                File jbossWebDD;
                File webDD = new File(warDir, "WEB-INF/web.xml");
                if (webDD.exists()) {
                    webIS = new FileInputStream(webDD);
                }
                if ((jbossWebDD = new File(warDir, "WEB-INF/jboss-web.xml")).exists()) {
                    jbossWebIS = new FileInputStream(jbossWebDD);
                }
            } else {
                ZipEntry entry;
                InputStream warIS = warURL.openStream();
                ZipInputStream zipIS = new ZipInputStream(warIS);
                byte[] buffer = new byte[512];
                while ((entry = zipIS.getNextEntry()) != null) {
                    int bytes;
                    ByteArrayOutputStream baos;
                    if (entry.getName().equals("WEB-INF/web.xml")) {
                        baos = new ByteArrayOutputStream();
                        while ((bytes = zipIS.read(buffer)) > 0) {
                            baos.write(buffer, 0, bytes);
                        }
                        webIS = new ByteArrayInputStream(baos.toByteArray());
                        continue;
                    }
                    if (!entry.getName().equals("WEB-INF/jboss-web.xml")) continue;
                    baos = new ByteArrayOutputStream();
                    while ((bytes = zipIS.read(buffer)) > 0) {
                        baos.write(buffer, 0, bytes);
                    }
                    jbossWebIS = new ByteArrayInputStream(baos.toByteArray());
                }
                zipIS.close();
            }
            try {
                XmlFileLoader xmlLoader = new XmlFileLoader();
                if (webIS != null) {
                    Document webDoc = xmlLoader.getDocument(webIS, "WEB-INF/web.xml");
                    Element web = webDoc.getDocumentElement();
                    metaData.importXml(web);
                }
                if (jbossWebIS != null) {
                    Document jbossWebDoc = xmlLoader.getDocument(jbossWebIS, "WEB-INF/jboss-web.xml");
                    Element jbossWeb = jbossWebDoc.getDocumentElement();
                    metaData.importXml(jbossWeb);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            this.log.trace("Failed to parse descriptors for war(" + warUrl + ")", e);
        }
        if ((defaultWebContext = ctxPath) != null && defaultWebContext.charAt(0) == '\u0000' && ((defaultWebContext = defaultWebContext.substring(1)).endsWith(".war") || defaultWebContext.endsWith(".WAR"))) {
            defaultWebContext = defaultWebContext.substring(0, defaultWebContext.length() - 4);
        }
        if ((webContext = metaData.getContextRoot()) == null && (webContext = defaultWebContext).equals("ROOT")) {
            webContext = "";
        }
        if (webContext.length() > 0 && webContext.charAt(0) != '/') {
            webContext = "/" + webContext;
        } else if (webContext.equals("/")) {
            webContext = "";
        }
        metaData.setContextRoot(webContext);
        return metaData;
    }

    protected void parseWebAppDescriptors(ClassLoader loader, WebMetaData metaData) throws Exception {
        this.log.debug("Begin parseWebAppDescriptors");
        InitialContext iniCtx = new InitialContext();
        Context envCtx = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        this.log.debug("TCL=" + currentLoader);
        try {
            Thread.currentThread().setContextClassLoader(loader);
            envCtx = (Context)iniCtx.lookup("java:comp");
            envCtx.bind("UserTransaction", (Object)new LinkRef("UserTransaction"));
            this.log.debug("Linking java:comp/UserTransaction to JNDI name: UserTransaction");
            envCtx = envCtx.createSubcontext("env");
        }
        finally {
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        Iterator envEntries = metaData.getEnvironmentEntries();
        this.log.debug("addEnvEntries");
        this.addEnvEntries(envEntries, envCtx);
        Iterator resourceEnvRefs = metaData.getResourceEnvReferences();
        this.log.debug("linkResourceEnvRefs");
        this.linkResourceEnvRefs(resourceEnvRefs, envCtx);
        Iterator resourceRefs = metaData.getResourceReferences();
        this.log.debug("linkResourceRefs");
        this.linkResourceRefs(resourceRefs, envCtx);
        Iterator ejbRefs = metaData.getEjbReferences();
        this.log.debug("linkEjbRefs");
        this.linkEjbRefs(ejbRefs, envCtx);
        Iterator ejbLocalRefs = metaData.getEjbLocalReferences();
        this.log.debug("linkEjbLocalRefs");
        this.linkEjbLocalRefs(ejbLocalRefs, envCtx);
        String securityDomain = metaData.getSecurityDomain();
        this.log.debug("linkSecurityDomain");
        this.linkSecurityDomain(securityDomain, envCtx);
        this.log.debug("End parseWebAppDescriptors");
    }

    protected abstract void performDeploy(WebApplication var1, String var2, WebDescriptorParser var3) throws Exception;

    protected abstract void performUndeploy(String var1) throws Exception;

    public void setConfig(Element config) {
    }

    public synchronized void undeploy(String warUrl) throws DeploymentException {
        try {
            this.performUndeploy(warUrl);
            this.deploymentMap.remove(warUrl);
        }
        catch (DeploymentException e) {
            throw (DeploymentException)e.fillInStackTrace();
        }
        catch (Exception e) {
            throw new DeploymentException("Error during deploy", e);
        }
    }

    public static interface WebDescriptorParser {
        public void parseWebAppDescriptors(ClassLoader var1, WebMetaData var2) throws Exception;
    }

    private class DescriptorParser
    implements WebDescriptorParser {
        DescriptorParser() {
        }

        public void parseWebAppDescriptors(ClassLoader loader, WebMetaData metaData) throws Exception {
            AbstractWebContainer.this.parseWebAppDescriptors(loader, metaData);
        }
    }
}

