/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class QueueRequestor {
    private QueueSession _queueSession = null;
    private Queue _queue = null;
    private QueueSender _requestSender = null;
    private QueueReceiver _replyReceiver = null;
    private TemporaryQueue _replyQueue = null;

    public QueueRequestor(QueueSession queueSession, Queue queue) throws JMSException {
        this._queueSession = queueSession;
        this._queue = queue;
        this._requestSender = this._queueSession.createSender(this._queue);
        this._replyQueue = this._queueSession.createTemporaryQueue();
        this._replyReceiver = this._queueSession.createReceiver(this._replyQueue);
    }

    public void close() throws JMSException {
        this._requestSender.close();
        this._replyReceiver.close();
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this._replyQueue);
        message.setJMSDeliveryMode(1);
        this._requestSender.send(message);
        return this._replyReceiver.receive();
    }
}

