/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.LinkedList;
import org.jboss.security.SimplePrincipal;

public class NestablePrincipal
extends SimplePrincipal
implements Group {
    private LinkedList principalStack = new LinkedList();

    public NestablePrincipal(String name) {
        super(name);
    }

    public Enumeration members() {
        return new IndexEnumeration();
    }

    public boolean removeMember(Principal user) {
        return this.principalStack.remove(user);
    }

    public boolean addMember(Principal user) {
        this.principalStack.addFirst(user);
        return true;
    }

    public boolean isMember(Principal member) {
        if (this.principalStack.size() == 0) {
            return false;
        }
        Object activePrincipal = this.principalStack.getFirst();
        return member.equals(activePrincipal);
    }

    private class IndexEnumeration
    implements Enumeration {
        private boolean hasMoreElements;

        IndexEnumeration() {
            this.hasMoreElements = NestablePrincipal.this.principalStack.size() > 0;
        }

        public boolean hasMoreElements() {
            return this.hasMoreElements;
        }

        public Object nextElement() {
            Object next = NestablePrincipal.this.principalStack.getFirst();
            this.hasMoreElements = false;
            return next;
        }
    }
}

