/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.hsql.Row;

class Node {
    int iBalance;
    int iLeft;
    int iRight;
    int iParent;
    Node nLeft;
    Node nRight;
    Node nParent;
    private int iId;
    Node nNext;
    Row rData;

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
        this.iParent = 0;
        this.iRight = 0;
        this.iLeft = 0;
    }

    int getKey() {
        return this.rData.iPos;
    }

    Node getLeft() throws SQLException {
        if (this.iLeft == 0) {
            return this.nLeft;
        }
        return this.rData.getNode(this.iLeft, this.iId);
    }

    void setLeft(Node node) throws SQLException {
        this.rData.changed();
        if (node == null) {
            this.iLeft = 0;
            this.nLeft = null;
        } else if (node.rData.iPos != 0) {
            this.iLeft = node.rData.iPos;
        } else {
            this.nLeft = node;
        }
    }

    Node getRight() throws SQLException {
        if (this.iRight == 0) {
            return this.nRight;
        }
        return this.rData.getNode(this.iRight, this.iId);
    }

    void setRight(Node node) throws SQLException {
        this.rData.changed();
        if (node == null) {
            this.iRight = 0;
            this.nRight = null;
        } else if (node.rData.iPos != 0) {
            this.iRight = node.rData.iPos;
        } else {
            this.nRight = node;
        }
    }

    Node getParent() throws SQLException {
        if (this.iParent == 0) {
            return this.nParent;
        }
        return this.rData.getNode(this.iParent, this.iId);
    }

    void setParent(Node node) throws SQLException {
        this.rData.changed();
        if (node == null) {
            this.iParent = 0;
            this.nParent = null;
        } else if (node.rData.iPos != 0) {
            this.iParent = node.rData.iPos;
        } else {
            this.nParent = node;
        }
    }

    int getBalance() throws SQLException {
        return this.iBalance;
    }

    void setBalance(int n) throws SQLException {
        if (this.iBalance != n) {
            this.rData.changed();
            this.iBalance = n;
        }
    }

    public Object[] getData() throws SQLException {
        return this.rData.getData();
    }

    boolean equals(Node node) throws SQLException {
        return node == this;
    }

    void write(DataOutput dataOutput) throws IOException, SQLException {
        dataOutput.writeInt(this.iBalance);
        dataOutput.writeInt(this.iLeft);
        dataOutput.writeInt(this.iRight);
        dataOutput.writeInt(this.iParent);
        if (this.nNext != null) {
            this.nNext.write(dataOutput);
        }
    }

    Node(Row row, DataInput dataInput, int n) throws IOException, SQLException {
        this.iId = n;
        this.rData = row;
        this.iBalance = dataInput.readInt();
        this.iLeft = dataInput.readInt();
        this.iRight = dataInput.readInt();
        this.iParent = dataInput.readInt();
    }

    Node(Row row, int n) {
        this.iId = n;
        this.rData = row;
    }
}

