/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.LinkedList;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;

public class SpyConnectionConsumer
implements ConnectionConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger(class$org$jboss$mq$SpyConnectionConsumer != null ? class$org$jboss$mq$SpyConnectionConsumer : (class$org$jboss$mq$SpyConnectionConsumer = SpyConnectionConsumer.class$("org.jboss.mq.SpyConnectionConsumer")));
    Connection connection;
    Destination destination;
    ServerSessionPool serverSessionPool;
    int maxMessages;
    LinkedList queue = new LinkedList();
    boolean closed = false;
    boolean waitingForMessage = false;
    Subscription subscription = new Subscription();
    Thread internalThread;
    static /* synthetic */ Class class$org$jboss$mq$SpyConnectionConsumer;

    public SpyConnectionConsumer(Connection connection, Destination destination, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this.connection = connection;
        this.destination = destination;
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = maxMessages;
        this.subscription.destination = (SpyDestination)destination;
        this.subscription.messageSelector = messageSelector;
        this.subscription.noLocal = false;
        connection.addConsumer(this);
        this.internalThread = new Thread((Runnable)this, "Connection Consumer for dest " + destination);
        this.internalThread.start();
    }

    public void addMessage(SpyMessage mes) throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace(this + "->addMessage(mes=" + mes + ")");
        }
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.closed) {
                log.debug("WARNING: NACK issued. The connection consumer was closed.");
                this.connection.send(mes.getAcknowledgementRequest(false));
                Object var3_3 = null;
                return;
            }
            if (this.waitingForMessage) {
                this.queue.addLast(mes);
                this.queue.notifyAll();
            } else {
                this.connection.send(mes.getAcknowledgementRequest(false));
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws JMSException {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.closed) {
                Object var2_2 = null;
                return;
            }
            this.closed = true;
            this.queue.notifyAll();
        }
        if (this.internalThread != null && !this.internalThread.equals(Thread.currentThread())) {
            try {
                this.internalThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.queue.isEmpty()) {
                SpyMessage message = (SpyMessage)this.queue.removeFirst();
                this.connection.send(message.getAcknowledgementRequest(false));
            }
            this.connection.removeConsumer(this);
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void run() {
        SpyMessage mes = null;
        try {
            boolean trace = log.isTraceEnabled();
            while (true) {
                if (mes == null) {
                    LinkedList linkedList = this.queue;
                    synchronized (linkedList) {
                        mes = this.connection.receive(this.subscription, 0L);
                        if (mes == null) {
                            this.waitingForMessage = true;
                            while (this.queue.isEmpty() && !this.closed) {
                                try {
                                    this.queue.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if (this.closed) {
                                this.waitingForMessage = false;
                                Object var4_5 = null;
                                break;
                            }
                            mes = (SpyMessage)this.queue.removeFirst();
                            this.waitingForMessage = false;
                        }
                        continue;
                    }
                }
                ServerSession serverSession = this.serverSessionPool.getServerSession();
                SpySession spySession = (SpySession)serverSession.getSession();
                if (spySession.sessionConsumer == null) {
                    log.debug(this + " Session did not have a set MessageListener");
                } else {
                    spySession.sessionConsumer.subscription = this.subscription;
                }
                spySession.addMessage(mes);
                if (trace) {
                    log.trace(this + " Starting the ServerSession.");
                }
                serverSession.start();
                mes = null;
            }
        }
        catch (JMSException e) {
            log.warn("Connection consumer closing due to error in listening thread.", e);
            try {
                if (mes != null) {
                    this.connection.send(mes.getAcknowledgementRequest(false));
                }
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        return "SpyConnectionConsumer:" + this.destination;
    }
}

