/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.jms.Destination;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyQueue;
import org.jboss.mq.SpyTopic;

public class SpyDestination
implements Destination,
Serializable {
    protected String name;
    protected int hash;
    protected static final int NULL = 0;
    protected static final int OBJECT = 1;
    protected static final int SPY_QUEUE = 2;
    protected static final int SPY_TOPIC = 3;

    SpyDestination(String name) {
        this.name = name;
        this.hash = name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.hash;
    }

    public static Destination readDest(ObjectInput in) throws IOException {
        byte destType = in.readByte();
        if (destType == 0) {
            return null;
        }
        if (destType == 2) {
            return new SpyQueue(in.readUTF());
        }
        if (destType == 3) {
            String name = in.readUTF();
            destType = in.readByte();
            if (destType == 0) {
                return new SpyTopic(name);
            }
            String clientId = SpyDestination.readString(in);
            String subName = SpyDestination.readString(in);
            return new SpyTopic(new SpyTopic(name), clientId, subName);
        }
        try {
            return (Destination)in.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class not found for unknown destination.");
        }
    }

    private static String readString(ObjectInput in) throws IOException {
        byte b = in.readByte();
        if (b == 0) {
            return null;
        }
        return in.readUTF();
    }

    public static void writeDest(ObjectOutput out, Destination dest) throws IOException {
        if (dest == null) {
            out.writeByte(0);
        } else if (dest instanceof SpyQueue) {
            out.writeByte(2);
            out.writeUTF(((SpyQueue)dest).getName());
        } else if (dest instanceof SpyTopic) {
            out.writeByte(3);
            out.writeUTF(((SpyTopic)dest).getName());
            DurableSubcriptionID id = ((SpyTopic)dest).durableSubscriptionID;
            if (id == null) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                SpyDestination.writeString(out, id.getClientID());
                SpyDestination.writeString(out, id.getSubscriptionName());
            }
        } else {
            out.writeByte(1);
            out.writeObject(dest);
        }
    }

    private static void writeString(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }
}

