/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import org.jboss.mq.SpyMessage;

public class SpyTextMessage
extends SpyMessage
implements Cloneable,
TextMessage,
Externalizable {
    private static final long serialVersionUID = 235726945332013953L;
    public static final int MAX_UTF_LENGTH = 21845;
    String content = null;

    public void clearBody() throws JMSException {
        this.content = null;
        super.clearBody();
    }

    public String getText() throws JMSException {
        return this.content;
    }

    public final boolean isVersion2() {
        boolean canWriteUTF;
        if (this.content == null) {
            return false;
        }
        int length = this.content.length();
        boolean bl = canWriteUTF = length < 21845;
        if (!canWriteUTF && length <= 65535) {
            char[] tmp = new char[length];
            this.content.getChars(0, length, tmp, 0);
            int writeUTFLength = 0;
            int n = 0;
            while (n < length) {
                char c = tmp[n];
                writeUTFLength = c >= '\u0001' && c <= '\u007f' ? ++writeUTFLength : (c > '\u07ff' ? (writeUTFLength += 3) : (writeUTFLength += 2));
                ++n;
            }
            canWriteUTF = writeUTFLength <= 65535;
        }
        return canWriteUTF ^ true;
    }

    public SpyMessage myClone() throws JMSException {
        SpyTextMessage result = new SpyTextMessage();
        result.copyProps(this);
        result.content = this.content;
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte type = in.readByte();
        if (type == 9) {
            this.content = null;
        } else if (type == 8) {
            this.content = in.readUTF();
        } else {
            int chunksToRead = in.readInt();
            StringBuffer sb = new StringBuffer(21845 * chunksToRead);
            int i = 0;
            while (i < chunksToRead) {
                sb.append(in.readUTF());
                ++i;
            }
            this.content = sb.toString();
        }
    }

    public void setText(String string) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("Cannot set the content");
        }
        this.content = string;
    }

    public String toString() {
        try {
            return "TextMessage@" + this.getText();
        }
        catch (JMSException jMSException) {
            return "toString() failed !";
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.content == null) {
            out.writeByte(9);
        } else if (this.isVersion2()) {
            out.writeByte(10);
            int chunks = this.content.length() / 21845;
            if (this.content.length() % 21845 > 0) {
                ++chunks;
            }
            out.writeInt(chunks);
            int i = 0;
            while (i < chunks) {
                int beginCopy = i * 21845;
                int endCopy = beginCopy + 21845;
                if (endCopy > this.content.length()) {
                    endCopy = this.content.length();
                }
                out.writeUTF(this.content.substring(beginCopy, endCopy));
                ++i;
            }
        } else {
            out.writeByte(8);
            out.writeUTF(this.content);
        }
    }
}

