/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;
import org.jboss.mq.Connection;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.SpyTopicPublisher;
import org.jboss.mq.SpyTopicSubscriber;

public class SpyTopicSession
extends SpySession
implements TopicSession,
XATopicSession {
    SpyTopicSession(Connection myConnection, boolean transacted, int acknowledgeMode) {
        this(myConnection, transacted, acknowledgeMode, false);
    }

    SpyTopicSession(Connection myConnection, boolean transacted, int acknowledgeMode, boolean xaSession) {
        super(myConnection, transacted, acknowledgeMode, xaSession);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.connection.getClientID(), name);
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, t, false, null);
        this.addConsumer(sub);
        return sub;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.connection.getClientID(), name);
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, t, noLocal, messageSelector);
        this.addConsumer(sub);
        return sub;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return new SpyTopicPublisher(this, topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, (SpyTopic)topic, noLocal, messageSelector);
        this.addConsumer(sub);
        return sub;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return ((SpyConnection)this.connection).getTemporaryTopic();
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return ((SpyConnection)this.connection).createTopic(topicName);
    }

    public TopicSession getTopicSession() throws JMSException {
        return this;
    }

    public void unsubscribe(String name) throws JMSException {
        DurableSubcriptionID id = new DurableSubcriptionID(this.connection.getClientID(), name);
        this.connection.unsubscribe(id);
    }
}

