/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.mq.SpySession;

public class SpyXAResource
implements XAResource {
    SpySession session;

    SpyXAResource(SpySession session) {
        this.session = session;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.session.connection.spyXAResourceManager.commit(xid, onePhase);
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.session.currentTransactionId == null) {
            throw new XAException(-9);
        }
        Object object = this.session.runLock;
        synchronized (object) {
            switch (flags) {
                case 0x2000000: {
                    this.session.currentTransactionId = null;
                    this.session.connection.spyXAResourceManager.suspendTx(xid);
                    break;
                }
                case 0x20000000: {
                    this.session.currentTransactionId = null;
                    this.session.connection.spyXAResourceManager.endTx(xid, false);
                    break;
                }
                case 0x4000000: {
                    this.session.currentTransactionId = null;
                    this.session.connection.spyXAResourceManager.endTx(xid, true);
                    break;
                }
            }
        }
    }

    public void forget(Xid arg1) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource arg1) throws XAException {
        if (!(arg1 instanceof SpyXAResource)) {
            return false;
        }
        return ((SpyXAResource)arg1).session.connection.spyXAResourceManager == this.session.connection.spyXAResourceManager;
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.session.connection.spyXAResourceManager.prepare(xid);
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    public Xid[] recover(int arg1) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.session.connection.spyXAResourceManager.rollback(xid);
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    public boolean setTransactionTimeout(int arg1) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        boolean convertTx = false;
        if (this.session.currentTransactionId != null) {
            if (flags == 0 && this.session.currentTransactionId instanceof Long) {
                convertTx = true;
            } else {
                throw new XAException(-9);
            }
        }
        Object object = this.session.runLock;
        synchronized (object) {
            switch (flags) {
                case 0: {
                    if (convertTx) {
                        this.session.currentTransactionId = this.session.connection.spyXAResourceManager.convertTx((Long)this.session.currentTransactionId, xid);
                        break;
                    }
                    this.session.currentTransactionId = this.session.connection.spyXAResourceManager.startTx(xid);
                    break;
                }
                case 0x200000: {
                    this.session.currentTransactionId = this.session.connection.spyXAResourceManager.joinTx(xid);
                    break;
                }
                case 0x8000000: {
                    this.session.currentTransactionId = this.session.connection.spyXAResourceManager.resumeTx(xid);
                    break;
                }
            }
            this.session.runLock.notify();
        }
    }
}

