/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.SpyMessage;

public class TransactionRequest
implements Serializable,
Externalizable {
    public byte requestType = 0;
    public Object xid;
    public SpyMessage[] messages;
    public AcknowledgementRequest[] acks;
    public static final byte ONE_PHASE_COMMIT_REQUEST = 0;
    public static final byte TWO_PHASE_COMMIT_COMMIT_REQUEST = 2;
    public static final byte TWO_PHASE_COMMIT_PREPARE_REQUEST = 1;
    public static final byte TWO_PHASE_COMMIT_ROLLBACK_REQUEST = 3;

    public void readExternal(ObjectInput in) throws IOException {
        this.requestType = in.readByte();
        try {
            this.xid = in.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class not found for xid.");
        }
        int size = in.readInt();
        this.messages = new SpyMessage[size];
        int i = 0;
        while (i < size) {
            this.messages[i] = SpyMessage.readMessage(in);
            ++i;
        }
        size = in.readInt();
        this.acks = new AcknowledgementRequest[size];
        int i2 = 0;
        while (i2 < size) {
            this.acks[i2] = new AcknowledgementRequest();
            this.acks[i2].readExternal(in);
            ++i2;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeByte(this.requestType);
        out.writeObject(this.xid);
        if (this.messages == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.messages.length);
            i = 0;
            while (i < this.messages.length) {
                SpyMessage.writeMessage(this.messages[i], out);
                ++i;
            }
        }
        if (this.acks == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.acks.length);
            i = 0;
            while (i < this.acks.length) {
                this.acks[i].writeExternal(out);
                ++i;
            }
        }
    }
}

