/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.jms;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.mq.cluster.jms.ClusterTopicConnection;
import org.jboss.mq.cluster.jms.ClusterTopicPublisher;
import org.jboss.mq.cluster.jms.ClusterTopicSubscriber;

public class ClusterTopicSession
implements TopicSession {
    protected HashSet consumers = new HashSet();
    boolean closed;
    ClusterTopicConnection connection;

    ClusterTopicSession(ClusterTopicConnection myConnection) {
        this.connection = myConnection;
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator i = this.consumers.iterator();
        while (i.hasNext()) {
            ClusterTopicSubscriber s = (ClusterTopicSubscriber)i.next();
            s.close();
        }
        this.connection.sessionClosing(this);
    }

    public void commit() throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyBytesMessage message = new SpyBytesMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMapMessage message = new SpyMapMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public Message createMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMessage message = new SpyMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = new SpyObjectMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = new SpyObjectMessage();
        message.setObject(object);
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return new ClusterTopicPublisher(this, topic);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyStreamMessage message = new SpyStreamMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        ClusterTopicSubscriber sub = new ClusterTopicSubscriber(this, topic, noLocal, messageSelector);
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.add(sub);
            this.consumers = newMap;
        }
        this.connection.addConsumer(sub);
        return sub;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.connection.getTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = new SpyTextMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = new SpyTextMessage();
        message.setText(string);
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.connection.createTopic(topicName);
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public boolean getTransacted() throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public void recover() throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public void rollback() throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public void run() {
    }

    public void setMessageListener(MessageListener arg1) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }
}

