/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.transport.udp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Category;
import org.jboss.mq.cluster.transport.udp.Datagram;
import org.jboss.mq.cluster.transport.udp.UDPNodeId;
import org.jboss.mq.cluster.transport.udp.UDPTransport;

class UDPStream
implements Runnable {
    public String name;
    UDPTransport transport;
    DatagramSocket socket;
    private Thread runningThread;
    private boolean done = false;
    private int maxSentCacheSize = 200;
    private int nextDatagramId = 0;
    private LinkedList sentCache = new LinkedList();
    private HashMap nodes = new HashMap(10);
    static Category cat = Category.getInstance((Class)(class$org$jboss$mq$cluster$transport$udp$UDPStream != null ? class$org$jboss$mq$cluster$transport$udp$UDPStream : (class$org$jboss$mq$cluster$transport$udp$UDPStream = UDPStream.class$("org.jboss.mq.cluster.transport.udp.UDPStream"))));
    private static final int MAX_DATAGRAM_STREAM_SIZE = 100;
    static /* synthetic */ Class class$org$jboss$mq$cluster$transport$udp$UDPStream;

    UDPStream() {
    }

    void addToSentCache(Datagram dg) {
        if (dg.isMessageFlagsSet(1)) {
            return;
        }
        LinkedList linkedList = this.sentCache;
        synchronized (linkedList) {
            this.sentCache.addFirst(dg);
            if (this.sentCache.size() > this.maxSentCacheSize) {
                this.sentCache.removeLast();
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void dispatchDatagrams(NodeState nodeState) throws InterruptedException {
        if (nodeState.datagramStream.size() == 0) {
            return;
        }
        boolean atFront = true;
        Object lastDS = nodeState.datagramStream.getLast();
        Iterator i = nodeState.datagramStream.iterator();
        MessageState firstMissing = null;
        Vector<Integer> missingList = new Vector<Integer>();
        while (i.hasNext()) {
            MessageState ds = (MessageState)i.next();
            if (ds.arrived) {
                if (!atFront && ds.fragments[0].isMessageFlagsSet(2)) continue;
                this.transport.datagramArrived(ds.fragments[0]);
                i.remove();
                continue;
            }
            atFront = false;
            if (ds == lastDS) continue;
            if (ds.isDropable) {
                i.remove();
                continue;
            }
            if (firstMissing == null) {
                firstMissing = ds;
            }
            missingList.addElement(new Integer(ds.id));
        }
        if (firstMissing != null && System.currentTimeMillis() - firstMissing.lastResendRequest > 200L) {
            this.transport.requestResend(nodeState.nodeId, missingList, this == this.transport.broadcastStream);
            firstMissing.lastResendRequest = System.currentTimeMillis();
        }
    }

    private synchronized void fragmentArrived(Datagram dg) throws InterruptedException {
        UDPNodeId senderId = dg.getSenderId();
        int id = dg.getId();
        short fragmentId = dg.getFragmentId();
        cat.debug((Object)("[" + this + "] Processing datagram: " + id));
        NodeState nodeState = this.getNodeState(senderId);
        MessageState ds = this.getMessageState(nodeState, id);
        if (ds == null || ds.arrived) {
            return;
        }
        if (dg.getFragmentCount(this.transport.maxFragmentSize) == 1) {
            ds.arrived = true;
            ds.fragments = new Datagram[1];
            ds.fragments[0] = dg;
        } else {
            if (ds.fragments == null) {
                ds.fragments = new Datagram[dg.getFragmentCount(this.transport.maxFragmentSize)];
                ds.isDropable = dg.isMessageFlagsSet(1);
            }
            ds.fragments[fragmentId] = dg;
            boolean messageLoaded = true;
            int i = ds.fragments.length - 1;
            while (i >= 0) {
                if (ds.fragments[i] == null) {
                    messageLoaded = false;
                    break;
                }
                --i;
            }
            if (messageLoaded) {
                int i2 = 0;
                while (i2 < ds.fragments.length - 1) {
                    ds.fragments[i2].nextFragment = ds.fragments[i2 + 1];
                    ++i2;
                }
                ds.arrived = true;
            }
        }
    }

    public Datagram getFromSentCache(int messageId) {
        LinkedList t;
        LinkedList linkedList = this.sentCache;
        synchronized (linkedList) {
            t = (LinkedList)this.sentCache.clone();
        }
        Iterator i = t.iterator();
        while (i.hasNext()) {
            Datagram dg = (Datagram)i.next();
            if (dg.getId() != messageId) continue;
            return dg;
        }
        return null;
    }

    private MessageState getMessageState(NodeState nodeState, int id) {
        boolean rollOver;
        boolean bl = rollOver = id < -5000 && nodeState.lastDatagramId > 5000;
        if (!nodeState.pastFirstPacket) {
            MessageState t = new MessageState(id);
            nodeState.datagramStream.addLast(t);
            nodeState.lastDatagramId = id;
            nodeState.pastFirstPacket = true;
            return t;
        }
        if (nodeState.lastDatagramId == id) {
            if (nodeState.datagramStream.size() == 0) {
                return null;
            }
            return (MessageState)nodeState.datagramStream.getLast();
        }
        if (nodeState.lastDatagramId < id || rollOver) {
            int i = nodeState.lastDatagramId;
            while (i != id) {
                MessageState t = new MessageState(++i);
                nodeState.datagramStream.addLast(t);
                if (nodeState.datagramStream.size() <= 100) continue;
                this.handleNodeUnresponsive(nodeState);
                nodeState.datagramStream.removeFirst();
            }
            nodeState.lastDatagramId = id;
            return (MessageState)nodeState.datagramStream.getLast();
        }
        Iterator i = nodeState.datagramStream.iterator();
        while (i.hasNext()) {
            MessageState ds = (MessageState)i.next();
            if (ds.id != id) continue;
            return ds;
        }
        return null;
    }

    protected int getNextDatagramId() {
        return this.nextDatagramId++;
    }

    private NodeState getNodeState(UDPNodeId nodeId) {
        NodeState rc = (NodeState)this.nodes.get(nodeId);
        if (rc == null) {
            rc = new NodeState();
            rc.nodeId = nodeId;
            this.nodes.put(nodeId, rc);
        }
        return rc;
    }

    private void handleNodeUnresponsive(NodeState nodeState) {
        cat.error((Object)"NODE IS UNRESPONSIVE!!!");
    }

    synchronized void removeFromDatagramStream(UDPNodeId nodeId, int datagramId) {
        NodeState nodeState = this.getNodeState(nodeId);
        Iterator i = nodeState.datagramStream.iterator();
        while (i.hasNext()) {
            MessageState ds = (MessageState)i.next();
            if (ds.id != datagramId) continue;
            ds.isDropable = true;
        }
    }

    public void run() {
        try {
            byte[] buffer = new byte[this.transport.maxFragmentSize + 17];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            this.socket.setSoTimeout(500);
            while (!this.done) {
                try {
                    Iterator i = this.nodes.values().iterator();
                    while (i.hasNext()) {
                        NodeState nodeState = (NodeState)i.next();
                        this.dispatchDatagrams(nodeState);
                    }
                    packet.setData(buffer);
                    packet.setLength(buffer.length);
                    this.socket.receive(packet);
                    if (packet.getLength() < 17) {
                        cat.info((Object)("[" + this + "] Packet was too small, dropping."));
                        continue;
                    }
                    Datagram dg = new Datagram(packet.getData(), packet.getLength());
                    dg.getSenderId().address = packet.getAddress();
                    if (this.transport.nodeId.equals(dg.getSenderId())) continue;
                    this.fragmentArrived(dg);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    synchronized void start() {
        if (this.runningThread != null) {
            return;
        }
        this.done = false;
        this.runningThread = new Thread((Runnable)this, "UDPStream-" + this.name);
        this.runningThread.start();
    }

    synchronized void stop() throws InterruptedException {
        if (this.runningThread == null) {
            return;
        }
        this.done = true;
        this.runningThread.interrupt();
        this.runningThread.join();
        this.runningThread = null;
    }

    public String toString() {
        return "org.jboss.mq.cluster.udp.UDPStream:" + this.name;
    }

    private static class MessageState {
        int id;
        boolean arrived = false;
        boolean isDropable = false;
        long lastResendRequest = 0L;
        Datagram[] fragments;

        MessageState(int id) {
            this.id = id;
        }
    }

    private static class NodeState {
        UDPNodeId nodeId;
        LinkedList datagramStream = new LinkedList();
        int lastDatagramId = 0;
        boolean pastFirstPacket = false;

        NodeState() {
        }
    }
}

