/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il;

import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnectionFactory;
import org.jboss.mq.SpyXAConnectionFactory;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXServiceMBean;
import org.jboss.mq.server.JMSServer;
import org.jboss.util.ServiceMBeanSupport;

public abstract class ServerILJMXService
extends ServiceMBeanSupport
implements ServerILJMXServiceMBean {
    private String connectionFactoryJNDIRef;
    private String xaConnectionFactoryJNDIRef;

    public void bindJNDIReferences() throws NamingException {
        GenericConnectionFactory gcf = new GenericConnectionFactory(this.getServerIL(), this.getClientConnectionProperties());
        SpyConnectionFactory scf = new SpyConnectionFactory(gcf);
        SpyXAConnectionFactory sxacf = new SpyXAConnectionFactory(gcf);
        InitialContext ctx = new InitialContext();
        ctx.bind(this.connectionFactoryJNDIRef, (Object)scf);
        ctx.bind(this.xaConnectionFactoryJNDIRef, (Object)sxacf);
    }

    public abstract Properties getClientConnectionProperties();

    public String getConnectionFactoryJNDIRef() {
        return this.connectionFactoryJNDIRef;
    }

    public abstract ServerIL getServerIL();

    public String getXAConnectionFactoryJNDIRef() {
        return this.xaConnectionFactoryJNDIRef;
    }

    public JMSServer lookupJMSServer() throws Exception {
        return (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
    }

    public void setConnectionFactoryJNDIRef(String newConnectionFactoryJNDIRef) {
        this.connectionFactoryJNDIRef = newConnectionFactoryJNDIRef;
    }

    public void setXAConnectionFactoryJNDIRef(String newXaConnectionFactoryJNDIRef) {
        this.xaConnectionFactoryJNDIRef = newXaConnectionFactoryJNDIRef;
    }

    public void unbindJNDIReferences() throws NamingException {
        InitialContext ctx = new InitialContext();
        ctx.unbind(this.connectionFactoryJNDIRef);
        ctx.unbind(this.xaConnectionFactoryJNDIRef);
    }
}

