/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.mq.il.uil.multiplexor.DemuxInputStream;

public class StreamDemux {
    short frameSize = (short)512;
    HashMap openStreams = new HashMap();
    InputStream in;
    DataInputStream objectIn;
    boolean pumpingData = false;
    byte[] inputBuffer = new byte[this.frameSize];

    public StreamDemux(InputStream in) throws IOException {
        this.in = in;
        this.objectIn = new DataInputStream(in);
    }

    public int available(DemuxInputStream s) throws IOException {
        return this.objectIn.available();
    }

    void closeStream(short id) throws IOException {
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            this.openStreams.remove(new Short(id));
        }
    }

    public short getFrameSize() {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            short s = this.frameSize;
            Object var3_3 = null;
            return s;
        }
    }

    public InputStream getStream(short id) throws IOException {
        InputStream s;
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            s = (InputStream)this.openStreams.get(new Short(id));
            if (s != null) {
                InputStream inputStream = s;
                Object var5_5 = null;
                return inputStream;
            }
            s = new DemuxInputStream(this, id);
            this.openStreams.put(new Short(id), s);
        }
        return s;
    }

    public boolean pumpData(DemuxInputStream dest) throws IOException {
        StreamDemux streamDemux = this;
        synchronized (streamDemux) {
            if (this.pumpingData) {
                boolean bl = false;
                Object var4_7 = null;
                return bl;
            }
            this.pumpingData = true;
        }
        short nextFrameSize = this.frameSize;
        block26: while (true) {
            DemuxInputStream s;
            Object object;
            short streamId;
            if ((streamId = this.objectIn.readShort()) == 0) {
                switch (this.objectIn.readByte()) {
                    default: {
                        continue block26;
                    }
                    case 0: {
                        this.getStream(this.objectIn.readShort());
                        continue block26;
                    }
                    case 1: {
                        object = this.openStreams;
                        synchronized (object) {
                            s = (DemuxInputStream)this.openStreams.get(new Short(this.objectIn.readShort()));
                        }
                        if (s == null) continue block26;
                        this.closeStream(s.streamId);
                        s.atEOF = true;
                        if (s == dest) continue block26;
                        object = s.bufferMutex;
                        synchronized (object) {
                            s.bufferMutex.notify();
                            continue block26;
                        }
                    }
                    case 2: 
                }
                nextFrameSize = this.objectIn.readShort();
                continue;
            }
            this.objectIn.readFully(this.inputBuffer, 0, nextFrameSize);
            object = this.openStreams;
            synchronized (object) {
                s = (DemuxInputStream)this.openStreams.get(new Short(streamId));
            }
            if (s == null) continue;
            s.loadBuffer(this.inputBuffer, nextFrameSize);
            if (s == dest) break;
            nextFrameSize = this.frameSize;
        }
        Object streamId = this;
        synchronized (streamId) {
            this.pumpingData = false;
        }
        streamId = this.openStreams;
        synchronized (streamId) {
            Iterator iter = this.openStreams.values().iterator();
            while (iter.hasNext() && !this.pumpingData) {
                DemuxInputStream s = (DemuxInputStream)iter.next();
                Object object = s.bufferMutex;
                synchronized (object) {
                    s.bufferMutex.notify();
                }
            }
        }
        return true;
    }

    public void setFrameSize(short newFrameSize) throws IOException {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            if (this.openStreams.size() > 0) {
                throw new IOException("Cannot change the frame size while there are open streams.");
            }
            this.frameSize = newFrameSize;
            this.inputBuffer = new byte[this.frameSize];
        }
    }
}

