/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.MemberFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class SourceFactory {
    private static final short BASE_TYPE_ENUMERATION = 0;
    private static final short OBJECT_TYPE_ENUMERATION = 1;
    private FieldInfoFactory infoFactory = null;
    private MemberFactory memberFactory = null;
    private short enumerationType = 1;
    private boolean _createMarshall = true;

    public SourceFactory() {
        this(null);
    }

    public SourceFactory(FieldInfoFactory fieldInfoFactory) {
        this.infoFactory = fieldInfoFactory == null ? new FieldInfoFactory() : fieldInfoFactory;
        this.memberFactory = new MemberFactory(fieldInfoFactory);
    }

    private void createMarshalMethods(JClass jClass) {
        JMethod jMethod = new JMethod(null, "marshal");
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(SGTypes.Writer, "out"));
        jClass.addMethod(jMethod);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("");
        jSourceCode.add("Marshaller.marshal(this, out);");
        jMethod = new JMethod(null, "marshal");
        JClass jClass2 = new JClass("org.xml.sax.DocumentHandler");
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(jClass2, "handler"));
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("");
        jSourceCode.add("Marshaller.marshal(this, handler);");
    }

    private void createPropertyChangeMethods(JClass jClass) {
        jClass.addImport("java.beans.PropertyChangeEvent");
        jClass.addImport("java.beans.PropertyChangeListener");
        String string = "propertyChangeListeners";
        JField jField = new JField(SGTypes.Vector, string);
        jField.getModifiers().makePrivate();
        jClass.addField(jField);
        JSourceCode jSourceCode = jClass.getConstructor(0).getSourceCode();
        jSourceCode.add("propertyChangeListeners = new Vector();");
        JMethod jMethod = new JMethod(null, "notifyPropertyChangeListeners");
        jMethod.getModifiers().makeProtected();
        String string2 = "Notifies all registered PropertyChangeListeners when a bound property's value changes.";
        JDocComment jDocComment = jMethod.getJDocComment();
        JDocDescriptor jDocDescriptor = null;
        jDocComment.appendComment(string2);
        jMethod.addParameter(new JParameter(SGTypes.String, "fieldName"));
        jDocDescriptor = jDocComment.getParamDescriptor("fieldName");
        jDocDescriptor.setDescription("the name of the property that has changed.");
        jMethod.addParameter(new JParameter(SGTypes.Object, "oldValue"));
        jDocDescriptor = jDocComment.getParamDescriptor("oldValue");
        jDocDescriptor.setDescription("the old value of the property.");
        jMethod.addParameter(new JParameter(SGTypes.Object, "newValue"));
        jDocDescriptor = jDocComment.getParamDescriptor("newValue");
        jDocDescriptor.setDescription("the new value of the property.");
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("java.beans.PropertyChangeEvent event = new ");
        jSourceCode.append("java.beans.PropertyChangeEvent");
        jSourceCode.append("(this, fieldName, oldValue, newValue);");
        jSourceCode.add("");
        jSourceCode.add("for (int i = 0; i < ");
        jSourceCode.append(string);
        jSourceCode.append(".size(); i++) {");
        jSourceCode.indent();
        jSourceCode.add("((java.beans.PropertyChangeListener) ");
        jSourceCode.append(string);
        jSourceCode.append(".elementAt(i)).");
        jSourceCode.append("propertyChange(event);");
        jSourceCode.unindent();
        jSourceCode.add("}");
        JClass jClass2 = new JClass("java.beans.PropertyChangeListener");
        jMethod = new JMethod(null, "addPropertyChangeListener");
        string2 = "Registers a PropertyChangeListener with this class.";
        jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment(string2);
        jMethod.addParameter(new JParameter(jClass2, "pcl"));
        string2 = "The PropertyChangeListener to register.";
        jDocDescriptor = jDocComment.getParamDescriptor("pcl");
        jDocDescriptor.setDescription(string2);
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(string);
        jSourceCode.append(".addElement(pcl);");
        jMethod = new JMethod(JType.Boolean, "removePropertyChangeListener");
        string2 = "Removes the given PropertyChangeListener from this classes list of ProperyChangeListeners.";
        jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment(string2);
        jMethod.addParameter(new JParameter(jClass2, "pcl"));
        string2 = "The PropertyChangeListener to remove.";
        jDocDescriptor = jDocComment.getParamDescriptor("pcl");
        jDocDescriptor.setDescription(string2);
        string2 = "true if the given PropertyChangeListener was removed.";
        jDocComment.addDescriptor(JDocDescriptor.createReturnDesc(string2));
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return ");
        jSourceCode.append(string);
        jSourceCode.append(".removeElement(pcl);");
    }

    public JClass createSourceCode(ComplexType complexType, ClassInfoResolver classInfoResolver, String string) {
        if (complexType == null) {
            throw new IllegalArgumentException("null ComplexType");
        }
        if (!complexType.isTopLevel()) {
            throw new IllegalArgumentException("ComplexType is not top-level.");
        }
        String string2 = JavaNaming.toJavaClassName(complexType.getName());
        string2 = this.resolveClassName(string2, string);
        FactoryState factoryState = new FactoryState(string2, classInfoResolver, string);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        factoryState.markAsProcessed(complexType);
        this.initialize(jClass);
        String string3 = SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
        if (string3 != null) {
            jClass.setSuperClass(string3);
        }
        if (SourceGenerator.mappingSchemaElement2Java()) {
            jClass.getModifiers().setAbstract(true);
        }
        classInfo.setNodeName(complexType.getName());
        Schema schema = complexType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        String string4 = this.processAnnotations(complexType);
        if (string4 != null) {
            jClass.getJDocComment().setComment(string4);
        }
        this.processComplexType(complexType, factoryState);
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.io.Reader");
        if (this._createMarshall) {
            this.createValidateMethods(jClass);
            if (!jClass.getModifiers().isAbstract()) {
                this.createMarshalMethods(jClass);
                this.createUnmarshalMethods(jClass);
            }
        }
        if (factoryState.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        if (classInfoResolver != null) {
            classInfoResolver.bindReference(jClass, classInfo);
            classInfoResolver.bindReference(complexType, classInfo);
        }
        return jClass;
    }

    public JClass createSourceCode(ElementDecl elementDecl, ClassInfoResolver classInfoResolver, String string) {
        XMLType xMLType;
        FactoryState factoryState = null;
        String string2 = elementDecl.getName();
        String string3 = JavaNaming.toJavaClassName(string2);
        string3 = this.resolveClassName(string3, string);
        factoryState = new FactoryState(string3, classInfoResolver, string);
        ElementDecl elementDecl2 = elementDecl;
        while (elementDecl2.isReference()) {
            elementDecl2 = elementDecl2.getReference();
        }
        factoryState.markAsProcessed(elementDecl2);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        this.initialize(jClass);
        String string4 = SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
        if (string4 != null) {
            jClass.setSuperClass(string4);
        }
        classInfo.setNodeName(elementDecl.getName());
        Schema schema = elementDecl.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        String string5 = this.processAnnotations(elementDecl);
        if (string5 != null) {
            jClass.getJDocComment().setComment(string5);
        }
        XMLType xMLType2 = elementDecl.getType();
        boolean bl = false;
        if (xMLType2 == null) {
            classInfo.setSchemaType(new XSClass(factoryState.jClass));
        } else if (xMLType2.isComplexType()) {
            xMLType = (ComplexType)xMLType2;
            if (!elementDecl.hasTypeReference()) {
                if (!factoryState.processed((ComplexType)xMLType)) {
                    this.processComplexType((ComplexType)xMLType, factoryState);
                }
                bl = factoryState.jClass.getSuperClass() != null;
            } else {
                String string6 = xMLType.getName();
                String string7 = JavaNaming.toJavaClassName(string6);
                string7 = this.resolveClassName(string7, string);
                jClass.setSuperClass(string7);
                bl = true;
            }
        } else {
            xMLType = (SimpleType)xMLType2;
            classInfo.setSchemaType(TypeConversion.convertType((SimpleType)xMLType));
            if (((SimpleType)xMLType).hasFacet("enumeration")) {
                this.createSourceCode((SimpleType)xMLType, (ClassInfoResolver)factoryState, factoryState.packageName);
            }
        }
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.io.Reader");
        if (this._createMarshall) {
            this.createValidateMethods(jClass);
            this.createMarshalMethods(jClass);
            this.createUnmarshalMethods(jClass);
        }
        boolean bl2 = bl;
        if (string4 != null) {
            bl2 = false;
        }
        if (factoryState.hasBoundProperties() && !bl2) {
            this.createPropertyChangeMethods(jClass);
        }
        if (classInfoResolver != null) {
            classInfoResolver.bindReference(jClass, classInfo);
            classInfoResolver.bindReference(elementDecl, classInfo);
        }
        return jClass;
    }

    public JClass createSourceCode(Group group, SGStateInfo sGStateInfo, String string) {
        String string2;
        String string3 = group.getName();
        if (string3 == null) {
            string3 = "Group" + sGStateInfo.getNextGroupNumber();
        }
        String string4 = JavaNaming.toJavaClassName(string3);
        string4 = this.resolveClassName(string4, string);
        FactoryState factoryState = new FactoryState(string4, sGStateInfo, string);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        factoryState.markAsProcessed(group);
        this.initialize(jClass);
        String string5 = SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
        if (string5 != null) {
            jClass.setSuperClass(string5);
        }
        if ((string2 = this.processAnnotations(group)) != null) {
            jClass.getJDocComment().setComment(string2);
        }
        this.processContentModel(group, factoryState);
        if (this._createMarshall) {
            jClass.addImport("java.io.Writer");
            jClass.addImport("java.io.Reader");
            this.createValidateMethods(jClass);
            if (!jClass.getModifiers().isAbstract()) {
                this.createMarshalMethods(jClass);
                this.createUnmarshalMethods(jClass);
            }
        }
        if (factoryState.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sGStateInfo.bindReference(jClass, classInfo);
        sGStateInfo.bindReference(group, classInfo);
        return jClass;
    }

    public JClass createSourceCode(SimpleType simpleType, ClassInfoResolver classInfoResolver, String string) {
        Object object;
        if (SimpleTypesFactory.isBuiltInType(simpleType.getTypeCode())) {
            String string2 = "You cannot construct a ClassInfo for a built-in SimpleType.";
            throw new IllegalArgumentException(string2);
        }
        boolean bl = false;
        String string3 = simpleType.getName();
        if (string3 == null) {
            object = simpleType.getParent();
            switch (((Structure)object).getStructureType()) {
                case 2: {
                    string3 = ((AttributeDecl)object).getName();
                    break;
                }
                case 7: {
                    string3 = ((ElementDecl)object).getName();
                    break;
                }
            }
            string3 = String.valueOf(string3) + "Type";
        }
        object = JavaNaming.toJavaClassName(string3);
        if (simpleType.hasFacet("enumeration")) {
            bl = true;
            string = string != null && string.length() > 0 ? String.valueOf(string) + ".types" : "types";
        }
        object = this.resolveClassName((String)object, string);
        FactoryState factoryState = new FactoryState((String)object, classInfoResolver, string);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        this.initialize(jClass);
        Schema schema = simpleType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        classInfo.setNodeName(string3);
        String string4 = this.processAnnotations(simpleType);
        if (string4 != null) {
            jClass.getJDocComment().setComment(string4);
        }
        XSClass xSClass = new XSClass(jClass, string3);
        classInfo.setSchemaType(xSClass);
        if (bl) {
            xSClass.setAsEnumertated(true);
            this.processEnumeration(simpleType, factoryState);
        }
        if (factoryState.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        if (classInfoResolver != null) {
            classInfoResolver.bindReference(jClass, classInfo);
            classInfoResolver.bindReference(simpleType, classInfo);
        }
        return jClass;
    }

    private void createUnmarshalMethods(JClass jClass) {
        String string = "unmarshal";
        if (SourceGenerator.mappingSchemaType2Java()) {
            string = String.valueOf(string) + jClass.getName(true);
        }
        JMethod jMethod = new JMethod(jClass, string);
        jMethod.getModifiers().setStatic(true);
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(SGTypes.Reader, "reader"));
        jClass.addMethod(jMethod);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return (");
        jSourceCode.append(jClass.getName());
        jSourceCode.append(") Unmarshaller.unmarshal(");
        jSourceCode.append(jClass.getName());
        jSourceCode.append(".class, reader);");
    }

    private void createValidateMethods(JClass jClass) {
        JMethod jMethod = null;
        JSourceCode jSourceCode = null;
        jMethod = new JMethod(null, "validate");
        jMethod.addException(SGTypes.ValidationException);
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("org.exolab.castor.xml.Validator validator = new ");
        jSourceCode.append("org.exolab.castor.xml.Validator();");
        jSourceCode.add("validator.validate(this);");
        jMethod = new JMethod(JType.Boolean, "isValid");
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("try {");
        jSourceCode.indent();
        jSourceCode.add("validate();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("catch (org.exolab.castor.xml.ValidationException vex) {");
        jSourceCode.indent();
        jSourceCode.add("return false;");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return true;");
        jClass.addMethod(jMethod);
    }

    private static String escapeValue(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void handleField(FieldInfo fieldInfo, FactoryState factoryState) {
        if (fieldInfo == null) {
            return;
        }
        JSourceCode jSourceCode = factoryState.jClass.getConstructor(0).getSourceCode();
        factoryState.classInfo.addFieldInfo(fieldInfo);
        fieldInfo.createJavaField(factoryState.jClass);
        if (!fieldInfo.isTransient()) {
            fieldInfo.createAccessMethods(factoryState.jClass);
            if (fieldInfo.isBound()) {
                factoryState.setBoundProperties(true);
            }
        }
        fieldInfo.generateInitializerCode(jSourceCode);
    }

    private void initialize(JClass jClass) {
        jClass.addInterface("java.io.Serializable");
        JConstructor jConstructor = jClass.createConstructor();
        jClass.addConstructor(jConstructor);
        jConstructor.getSourceCode().add("super();");
        jClass.addImport("org.exolab.castor.xml.*");
        jClass.addImport("java.io.Serializable");
    }

    private String processAnnotations(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Annotation annotation = (Annotation)enumeration.nextElement();
                Enumeration enumeration2 = annotation.getDocumentation();
                while (enumeration2.hasMoreElements()) {
                    Documentation documentation = (Documentation)enumeration2.nextElement();
                    String string = documentation.getContent();
                    if (string == null) continue;
                    stringBuffer.append(string);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private void processComplexType(ComplexType complexType, FactoryState factoryState) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = complexType.getName();
        ClassInfo classInfo = factoryState.classInfo;
        classInfo.setSchemaType(new XSClass(factoryState.jClass, string));
        Schema schema = complexType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        XMLType xMLType = complexType.getBaseType();
        if (xMLType != null && xMLType.isComplexType()) {
            object4 = null;
            if (xMLType.getSchema() == schema) {
                object3 = factoryState.resolve(xMLType);
                if (object3 == null) {
                    object2 = factoryState.jClass.getPackageName();
                    object = this.createSourceCode((ComplexType)xMLType, (ClassInfoResolver)factoryState, (String)object2);
                    object3 = factoryState.resolve(xMLType);
                    object4 = ((JType)object).getName();
                } else {
                    object4 = ((ClassInfo)object3).getJClass().getName();
                }
            } else {
                object4 = SourceGenerator.getQualifiedClassName(xMLType.getSchema().getTargetNamespace(), JavaNaming.toJavaClassName(xMLType.getName()));
            }
            factoryState.jClass.setSuperClass((String)object4);
        }
        if (xMLType != null && xMLType.isSimpleType()) {
            object4 = this.memberFactory.createFieldInfoForContent(TypeConversion.convertType((SimpleType)xMLType));
            this.handleField((FieldInfo)object4, factoryState);
        }
        object4 = complexType.getAttributeDecls();
        while (object4.hasMoreElements()) {
            object3 = (AttributeDecl)object4.nextElement();
            object2 = ((AttributeDecl)object3).getSimpleType();
            if (object2 != null && !SimpleTypesFactory.isBuiltInType(((SimpleType)object2).getTypeCode())) {
                this.createSourceCode((SimpleType)object2, (ClassInfoResolver)factoryState, factoryState.packageName);
            }
            object = this.memberFactory.createFieldInfo((AttributeDecl)object3, (ClassInfoResolver)factoryState);
            this.handleField((FieldInfo)object, factoryState);
        }
        object3 = complexType.getContentType();
        if (object3 == ContentType.mixed || object3 == ContentType.any) {
            object2 = this.memberFactory.createFieldInfoForContent(new XSString());
            this.handleField((FieldInfo)object2, factoryState);
            if (object3 == ContentType.any) {
                object2 = this.memberFactory.createFieldInfoForAny();
                this.handleField((FieldInfo)object2, factoryState);
            }
        }
        this.processContentModel(complexType, factoryState);
    }

    private void processContentModel(ContentModelGroup contentModelGroup, FactoryState factoryState) {
        Enumeration enumeration = contentModelGroup.enumerate();
        FieldInfo fieldInfo = null;
        while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 7: {
                    Particle particle;
                    Particle particle2 = (ElementDecl)structure;
                    boolean bl = false;
                    if (SourceGenerator.mappingSchemaElement2Java()) {
                        bl = true;
                    } else if (SourceGenerator.mappingSchemaType2Java() && (((ElementDecl)particle2).getType().getName() == null || ((ElementDecl)particle2).getType().isSimpleType())) {
                        bl = true;
                    }
                    if (bl) {
                        particle = particle2;
                        while (((ElementDecl)particle).isReference()) {
                            if ((particle = ((ElementDecl)particle).getReference()) != null) continue;
                            String string = "Unable to find element referenced :\" ";
                            string = String.valueOf(string) + ((ElementDecl)particle2).getName();
                            string = String.valueOf(string) + "\"";
                            throw new IllegalStateException(string);
                        }
                        boolean bl2 = factoryState.processed((ElementDecl)particle);
                        if (factoryState.resolve(structure) == null && !bl2) {
                            this.createSourceCode((ElementDecl)structure, (ClassInfoResolver)factoryState, factoryState.packageName);
                        }
                    }
                    fieldInfo = this.memberFactory.createFieldInfo((ElementDecl)structure, (ClassInfoResolver)factoryState);
                    this.handleField(fieldInfo, factoryState);
                    break;
                }
                case 9: {
                    Particle particle2 = (Group)structure;
                    if (contentModelGroup instanceof ComplexType) {
                        Order order = ((Group)particle2).getOrder();
                        if (order == Order.choice) {
                            factoryState.classInfo.setAsChoice();
                        } else if (order == Order.seq) {
                            factoryState.classInfo.setAsSequence();
                        } else {
                            factoryState.classInfo.setAsAll();
                        }
                    }
                    this.processContentModel((ContentModelGroup)((Object)particle2), factoryState);
                    break;
                }
                case 10: {
                    ModelGroup modelGroup = (ModelGroup)structure;
                    if (!modelGroup.hasReference()) break;
                    Particle particle = modelGroup.getReference();
                    if (particle == null) {
                        String string = "Unable to find group referenced :\" ";
                        string = String.valueOf(string) + modelGroup.getName();
                        string = String.valueOf(string) + "\"";
                        throw new IllegalStateException(string);
                    }
                    if (((ModelGroup)particle).getContentModelGroup() != null) {
                        this.processContentModel(((ModelGroup)particle).getContentModelGroup(), factoryState);
                        break;
                    }
                    String string = "<group> should contains :\" ";
                    string = String.valueOf(string) + " 'all' or 'sequence' or 'choice'";
                    string = String.valueOf(string) + "\"";
                    throw new IllegalStateException(string);
                }
            }
        }
    }

    private void processEnumeration(SimpleType simpleType, FactoryState factoryState) {
        switch (this.enumerationType) {
            case 0: {
                this.processEnumerationAsBaseType(simpleType, factoryState);
                break;
            }
            default: {
                this.processEnumerationAsNewObject(simpleType, factoryState);
            }
        }
    }

    private void processEnumerationAsBaseType(SimpleType simpleType, FactoryState factoryState) {
        Object object;
        SimpleType simpleType2 = (SimpleType)simpleType.getBaseType();
        XSType xSType = null;
        xSType = simpleType2 == null ? new XSString() : TypeConversion.convertType(simpleType2);
        Enumeration enumeration = simpleType.getFacets("enumeration");
        JClass jClass = factoryState.jClass;
        String string = jClass.getLocalName();
        JField jField = null;
        JDocComment jDocComment = null;
        JSourceCode jSourceCode = null;
        JConstructor jConstructor = jClass.getConstructor(0);
        jConstructor.getModifiers().makePrivate();
        jField = new JField(xSType.getJType().createArray(), "values");
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("{\n");
        while (enumeration.hasMoreElements()) {
            object = (Facet)enumeration.nextElement();
            String string2 = ((Facet)object).getValue();
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append("    ");
            if (xSType.getType() == 23) {
                stringBuffer.append('\"');
                stringBuffer.append(SourceFactory.escapeValue(string2));
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(string2);
            }
            ++n;
        }
        stringBuffer.append("\n}");
        jField.setInitString(stringBuffer.toString());
        jClass.addField(jField);
        object = new JMethod(jClass, "valueOf");
        ((JMethod)object).addParameter(new JParameter(SGTypes.String, "string"));
        ((JMethod)object).getModifiers().setStatic(true);
        jClass.addMethod((JMethod)object);
        jDocComment = ((JMethod)object).getJDocComment();
        jDocComment.appendComment("Returns the " + xSType.getJType());
        jDocComment.appendComment(" based on the given String value.");
        jSourceCode = ((JMethod)object).getSourceCode();
        jSourceCode.add("for (int i = 0; i < values.length; i++) {");
        jSourceCode.add("}");
        jSourceCode.add("throw new IllegalArgumentException(\"");
        jSourceCode.append("Invalid value for ");
        jSourceCode.append(string);
        jSourceCode.append(": \" + string + \".\");");
    }

    private void processEnumerationAsNewObject(SimpleType simpleType, FactoryState factoryState) {
        Object object;
        String string;
        Object object2;
        Enumeration enumeration = simpleType.getFacets("enumeration");
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            object2 = (Facet)enumeration.nextElement();
            string = ((Facet)object2).getValue().toUpperCase();
            if (JavaNaming.isValidJavaIdentifier(string)) continue;
            bl = false;
            break;
        }
        enumeration = simpleType.getFacets("enumeration");
        object2 = factoryState.jClass;
        string = ((JType)object2).getLocalName();
        JField jField = null;
        JField jField2 = new JField(SGTypes.Hashtable, "_memberTable");
        jField2.setInitString("init()");
        jField2.getModifiers().setStatic(true);
        JDocComment jDocComment = null;
        JSourceCode jSourceCode = null;
        JConstructor jConstructor = ((JClass)object2).getConstructor(0);
        jConstructor.getModifiers().makePrivate();
        jConstructor.addParameter(new JParameter(JType.Int, "type"));
        jConstructor.addParameter(new JParameter(SGTypes.String, "value"));
        jSourceCode = jConstructor.getSourceCode();
        jSourceCode.add("this.type = type;");
        jSourceCode.add("this.stringValue = value;");
        JMethod jMethod = new JMethod((JType)object2, "valueOf");
        jMethod.addParameter(new JParameter(SGTypes.String, "string"));
        jMethod.getModifiers().setStatic(true);
        ((JClass)object2).addMethod(jMethod);
        jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment("Returns a new " + string);
        jDocComment.appendComment(" based on the given String value.");
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("Object obj = null;");
        jSourceCode.add("if (string != null) ");
        jSourceCode.append("obj = _memberTable.get(string);");
        jSourceCode.add("if (obj == null) {");
        jSourceCode.indent();
        jSourceCode.add("String err = \"'\" + string + \"' is not a valid ");
        jSourceCode.append(string);
        jSourceCode.append("\";");
        jSourceCode.add("throw new IllegalArgumentException(err);");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return (");
        jSourceCode.append(string);
        jSourceCode.append(") obj;");
        JMethod jMethod2 = new JMethod(SGTypes.Enumeration, "enumerate");
        jMethod2.getModifiers().setStatic(true);
        ((JClass)object2).addMethod(jMethod2);
        jDocComment = jMethod2.getJDocComment();
        jDocComment.appendComment("Returns an enumeration of all possible instances of ");
        jDocComment.appendComment(string);
        jMethod2.getSourceCode().add("return _memberTable.elements();");
        JMethod jMethod3 = new JMethod(SGTypes.String, "toString");
        ((JClass)object2).addMethod(jMethod3);
        jDocComment = jMethod3.getJDocComment();
        jDocComment.appendComment("Returns the String representation of this ");
        jDocComment.appendComment(string);
        jMethod3.getSourceCode().add("return this.stringValue;");
        JMethod jMethod4 = new JMethod(SGTypes.Hashtable, "init");
        ((JClass)object2).addMethod(jMethod4);
        jMethod4.getModifiers().makePrivate();
        jMethod4.getModifiers().setStatic(true);
        jMethod4.getSourceCode().add("Hashtable members = new Hashtable();");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (Facet)enumeration.nextElement();
            String string2 = ((Facet)object).getValue();
            String string3 = null;
            String string4 = null;
            string4 = bl ? string2.toUpperCase() : "VALUE_" + n;
            string3 = String.valueOf(string4) + "_TYPE";
            jField = new JField(JType.Int, string3);
            jField.setComment("The " + string2 + " type");
            JModifiers jModifiers = jField.getModifiers();
            jModifiers.setFinal(true);
            jModifiers.setStatic(true);
            jModifiers.makePublic();
            jField.setInitString(Integer.toString(n));
            ((JClass)object2).addField(jField);
            jField = new JField((JType)object2, string4);
            jField.setComment("The instance of the " + string2 + " type");
            jModifiers = jField.getModifiers();
            jModifiers.setFinal(true);
            jModifiers.setStatic(true);
            jModifiers.makePublic();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("new ");
            stringBuffer.append(string);
            stringBuffer.append("(");
            stringBuffer.append(string3);
            stringBuffer.append(", \"");
            stringBuffer.append(string2);
            stringBuffer.append("\")");
            jField.setInitString(stringBuffer.toString());
            ((JClass)object2).addField(jField);
            jSourceCode = jMethod4.getSourceCode();
            jSourceCode.add("members.put(\"");
            jSourceCode.append(SourceFactory.escapeValue(string2));
            jSourceCode.append("\", ");
            jSourceCode.append(string4);
            jSourceCode.append(");");
            ++n;
        }
        jMethod4.getSourceCode().add("return members;");
        ((JClass)object2).addField(jField2);
        jField = new JField(JType.Int, "type");
        jField.setInitString("-1");
        ((JClass)object2).addField(jField);
        jField = new JField(SGTypes.String, "stringValue");
        jField.setInitString("null");
        ((JClass)object2).addField(jField);
        object = new JMethod(JType.Int, "getType");
        ((JMethod)object).getSourceCode().add("return this.type;");
        jDocComment = ((JMethod)object).getJDocComment();
        jDocComment.appendComment("Returns the type of this " + string);
        ((JClass)object2).addMethod((JMethod)object);
    }

    private String resolveClassName(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            return String.valueOf(string2) + "." + string;
        }
        return string;
    }

    public void setMarshallCreation(boolean bl) {
        this._createMarshall = bl;
    }
}

