/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.math.BigDecimal;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class XSDecimal
extends XSType {
    Integer _scale = null;
    Integer _precision = null;
    BigDecimal _maxInclusive = null;
    BigDecimal _maxExclusive = null;
    BigDecimal _minInclusive = null;
    BigDecimal _minExclusive = null;
    private static final JType jType = new JClass("java.math.BigDecimal");
    private String value = null;

    public XSDecimal() {
        super((short)6);
    }

    public String createFromJavaObjectCode(String string) {
        return "(java.math.BigDecimal)" + string;
    }

    public JType getJType() {
        return jType;
    }

    public BigDecimal getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigDecimal getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigDecimal getMinExclusive() {
        return this._minExclusive;
    }

    public BigDecimal getMinInclusive() {
        return this._minInclusive;
    }

    public Integer getPrecision() {
        return this._precision;
    }

    public Integer getScale() {
        return this._scale;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public String newInstanceCode() {
        String string = "new java.math.BigDecimal(0)";
        string = this._scale != null ? String.valueOf(string) + ".setScale(" + this._scale + ");" : String.valueOf(string) + ";";
        return string;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        try {
            while (enumeration.hasMoreElements()) {
                Facet facet = (Facet)enumeration.nextElement();
                String string = facet.getName();
                if ("maxExclusive".equals(string)) {
                    this.setMaxExclusive(new BigDecimal(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(string)) {
                    this.setMaxInclusive(new BigDecimal(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(string)) {
                    this.setMinExclusive(new BigDecimal(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(string)) {
                    this.setMinInclusive(new BigDecimal(facet.getValue()));
                    continue;
                }
                if ("precision".equals(string)) {
                    this.setPrecision(facet.toInt());
                    continue;
                }
                if (!"scale".equals(string)) continue;
                this.setScale(facet.toInt());
            }
        }
        catch (ValidationException validationException) {
            System.out.println("Error in setting up the Facets");
            System.out.println(validationException);
            return;
        }
    }

    public void setMaxExclusive(BigDecimal bigDecimal) {
        this._maxExclusive = bigDecimal;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(BigDecimal bigDecimal) {
        this._maxInclusive = bigDecimal;
        this._maxExclusive = null;
    }

    public void setMinExclusive(BigDecimal bigDecimal) {
        this._minExclusive = bigDecimal;
        this._minInclusive = null;
    }

    public void setMinInclusive(BigDecimal bigDecimal) {
        this._minInclusive = bigDecimal;
        this._minExclusive = null;
    }

    public void setPrecision(int n) throws ValidationException {
        String string = "";
        if (n < 0 || n == 0) {
            string = "decimal precision must be a positiveInteger";
            throw new ValidationException(string);
        }
        this._precision = new Integer(n);
    }

    public void setScale(int n) throws ValidationException {
        String string = "";
        if (n < 0) {
            string = "decimal scale must be a nonNegativeInteger";
            throw new ValidationException(string);
        }
        if (this._precision != null && n > this._precision) {
            string = "decimal scale must be lower than precision";
            throw new ValidationException(string);
        }
        this._scale = new Integer(n);
    }
}

