/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JType;

public final class XSLong
extends XSPatternBase {
    Long maxInclusive = null;
    Long maxExclusive = null;
    Long minInclusive = null;
    Long minExclusive = null;
    private static final JType jType = JType.Long;

    public XSLong() {
        super((short)14);
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Long)");
        stringBuffer.append(string);
        stringBuffer.append(").longValue()");
        return stringBuffer.toString();
    }

    public String createToJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("new Long(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public JType getJType() {
        return jType;
    }

    public Long getMaxExclusive() {
        return this.maxExclusive;
    }

    public Long getMaxInclusive() {
        return this.maxInclusive;
    }

    public Long getMinExclusive() {
        return this.minExclusive;
    }

    public Long getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toLong());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toLong());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toLong());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toLong());
                continue;
            }
            if (!"pattern".equals(string)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public void setMaxExclusive(long l) {
        this.maxExclusive = new Long(l);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Long l) {
        this.maxExclusive = l;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(long l) {
        this.maxInclusive = new Long(l);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Long l) {
        this.maxInclusive = l;
        this.maxExclusive = null;
    }

    public void setMinExclusive(long l) {
        this.minExclusive = new Long(l);
        this.minInclusive = null;
    }

    public void setMinExclusive(Long l) {
        this.minExclusive = l;
        this.minInclusive = null;
    }

    public void setMinInclusive(long l) {
        this.minInclusive = new Long(l);
        this.minExclusive = null;
    }

    public void setMinInclusive(Long l) {
        this.minInclusive = l;
        this.minExclusive = null;
    }
}

