/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.conf;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.jdo.conf.DataSource;
import org.exolab.castor.jdo.conf.Driver;
import org.exolab.castor.jdo.conf.Jndi;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.DocumentHandler;

public class Database
implements Serializable {
    private String _engine = "generic";
    private String _name;
    private Driver _driver;
    private DataSource _dataSource;
    private Jndi _jndi;
    private Vector _mappingList = new Vector();
    static /* synthetic */ Class class$org$exolab$castor$jdo$conf$Database;

    public void addMapping(Mapping mapping) throws IndexOutOfBoundsException {
        this._mappingList.addElement(mapping);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Enumeration enumerateMapping() {
        return this._mappingList.elements();
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public Driver getDriver() {
        return this._driver;
    }

    public String getEngine() {
        return this._engine;
    }

    public Jndi getJndi() {
        return this._jndi;
    }

    public Mapping[] getMapping() {
        int n = this._mappingList.size();
        Mapping[] mappingArray = new Mapping[n];
        int n2 = 0;
        while (n2 < n) {
            mappingArray[n2] = (Mapping)this._mappingList.elementAt(n2);
            ++n2;
        }
        return mappingArray;
    }

    public Mapping getMapping(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._mappingList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Mapping)this._mappingList.elementAt(n);
    }

    public int getMappingCount() {
        return this._mappingList.size();
    }

    public String getName() {
        return this._name;
    }

    public String getReferenceId() {
        return this._name;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    public void marshal(Writer writer) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, writer);
    }

    public void marshal(DocumentHandler documentHandler) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, documentHandler);
    }

    public void removeAllMapping() {
        this._mappingList.removeAllElements();
    }

    public Mapping removeMapping(int n) {
        Object e = this._mappingList.elementAt(n);
        this._mappingList.removeElementAt(n);
        return (Mapping)e;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setDriver(Driver driver) {
        this._driver = driver;
    }

    public void setEngine(String string) {
        this._engine = string;
    }

    public void setJndi(Jndi jndi) {
        this._jndi = jndi;
    }

    public void setMapping(Mapping mapping, int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._mappingList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._mappingList.setElementAt(mapping, n);
    }

    public void setName(String string) {
        this._name = string;
    }

    public static Database unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Database)Unmarshaller.unmarshal(class$org$exolab$castor$jdo$conf$Database != null ? class$org$exolab$castor$jdo$conf$Database : (class$org$exolab$castor$jdo$conf$Database = Database.class$("org.exolab.castor.jdo.conf.Database")), reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate(this);
    }
}

