/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class InterbaseQueryExpression
extends JDBCQueryExpression {
    private StringBuffer sql;

    public InterbaseQueryExpression(PersistenceFactory persistenceFactory) {
        super(persistenceFactory);
    }

    void appendJoin(JDBCQueryExpression.Join join) {
        if (join.outer) {
            this.sql.append(" LEFT OUTER JOIN ");
        } else {
            this.sql.append(" INNER JOIN ");
        }
        this.sql.append(this._factory.quoteName(join.rightTable)).append(" ON ");
        int n = 0;
        while (n < join.leftColumns.length) {
            if (n > 0) {
                this.sql.append(" AND ");
            }
            this.sql.append(this._factory.quoteName(String.valueOf(join.leftTable) + "." + join.leftColumns[n])).append("=");
            this.sql.append(this._factory.quoteName(String.valueOf(join.rightTable) + "." + join.rightColumns[n]));
            ++n;
        }
    }

    public String getStatement(boolean bl) {
        Vector<String> vector = new Vector<String>();
        this.sql = new StringBuffer();
        this.sql.append("SELECT ");
        if (this._distinct) {
            this.sql.append(" DISTINCT ");
        }
        if (this._select == null) {
            this.sql.append(this.getColumnList());
        } else {
            this.sql.append(this._select).append(" ");
        }
        this.sql.append(" FROM ");
        Hashtable hashtable = (Hashtable)this._tables.clone();
        boolean bl2 = true;
        int n = 0;
        while (n < this._joins.size()) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(n);
            if (!vector.contains(join.leftTable)) {
                if (bl2) {
                    bl2 = false;
                    this.sql.append(this._factory.quoteName(join.leftTable));
                }
                this.appendJoin(join);
                hashtable.remove(join.leftTable);
                hashtable.remove(join.rightTable);
                int n2 = n + 1;
                while (n2 < this._joins.size()) {
                    JDBCQueryExpression.Join join2 = (JDBCQueryExpression.Join)this._joins.elementAt(n2);
                    if (join.leftTable.equals(join2.leftTable)) {
                        this.appendJoin(join2);
                        hashtable.remove(join2.rightTable);
                    }
                    ++n2;
                }
                vector.addElement(join.leftTable);
            }
            ++n;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (bl2) {
                bl2 = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(this._factory.quoteName((String)enumeration.nextElement()));
        }
        bl2 = this.addWhereClause(this.sql, true);
        if (this._order != null) {
            this.sql.append(" ORDER BY ").append(this._order);
        }
        return this.sql.toString();
    }
}

