/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public class JDBCQueryExpression
implements QueryExpression {
    protected Hashtable _tables = new Hashtable();
    protected Vector _cols = new Vector();
    protected Vector _conds = new Vector();
    protected Vector _joins = new Vector();
    protected String _select;
    protected String _where;
    protected String _order;
    protected String _limit;
    protected boolean _distinct = false;
    protected PersistenceFactory _factory;
    static /* synthetic */ Class class$org$exolab$castor$persist$spi$PersistenceFactory;

    public JDBCQueryExpression(PersistenceFactory persistenceFactory) {
        this._factory = persistenceFactory;
    }

    public void addColumn(String string, String string2) {
        this._tables.put(string, string);
        this._cols.addElement(this._factory.quoteName(String.valueOf(string) + "." + string2));
    }

    public void addCondition(String string, String string2, String string3, String string4) {
        this._tables.put(string, string);
        this._conds.addElement(String.valueOf(this._factory.quoteName(String.valueOf(string) + "." + string2)) + string3 + string4);
    }

    public void addInnerJoin(String string, String string2, String string3, String string4) {
        this._tables.put(string, string);
        this._tables.put(string3, string3);
        this._joins.addElement(new Join(string, string2, string3, string4, false));
    }

    public void addInnerJoin(String string, String[] stringArray, String string2, String[] stringArray2) {
        this._tables.put(string, string);
        this._tables.put(string2, string2);
        this._joins.addElement(new Join(string, stringArray, string2, stringArray2, false));
    }

    public void addLimitClause(String string) {
        this._limit = string;
    }

    public void addOrderClause(String string) {
        this._order = string;
    }

    public void addOuterJoin(String string, String string2, String string3, String string4) {
        this._tables.put(string, string);
        this._tables.put(string3, string3);
        this._joins.addElement(new Join(string, string2, string3, string4, true));
    }

    public void addOuterJoin(String string, String[] stringArray, String string2, String[] stringArray2) {
        this._tables.put(string, string);
        this._tables.put(string2, string2);
        this._joins.addElement(new Join(string, stringArray, string2, stringArray2, true));
    }

    public void addParameter(String string, String string2, String string3) {
        this.addCondition(string, string2, string3, "?");
    }

    public void addSelect(String string) {
        this._select = string;
    }

    public void addTable(String string) {
        this._tables.put(string, string);
    }

    public void addWhereClause(String string) {
        this._where = string;
    }

    protected boolean addWhereClause(StringBuffer stringBuffer, boolean bl) {
        if (this._conds.size() > 0) {
            if (bl) {
                stringBuffer.append(" WHERE ");
                bl = false;
            } else {
                stringBuffer.append(" AND ");
            }
            int n = 0;
            while (n < this._conds.size()) {
                if (n > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append((String)this._conds.elementAt(n));
                ++n;
            }
        }
        if (this._where != null) {
            if (bl) {
                stringBuffer.append(" WHERE ");
                bl = false;
            } else {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append('(');
            stringBuffer.append(this._where);
            stringBuffer.append(')');
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        JDBCQueryExpression jDBCQueryExpression;
        try {
            jDBCQueryExpression = (JDBCQueryExpression)this.getClass().getConstructor(class$org$exolab$castor$persist$spi$PersistenceFactory != null ? class$org$exolab$castor$persist$spi$PersistenceFactory : (class$org$exolab$castor$persist$spi$PersistenceFactory = JDBCQueryExpression.class$("org.exolab.castor.persist.spi.PersistenceFactory"))).newInstance(this._factory);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        jDBCQueryExpression._tables = (Hashtable)this._tables.clone();
        jDBCQueryExpression._conds = (Vector)this._conds.clone();
        jDBCQueryExpression._cols = (Vector)this._cols.clone();
        jDBCQueryExpression._joins = (Vector)this._joins.clone();
        return jDBCQueryExpression;
    }

    public String encodeColumn(String string, String string2) {
        return this._factory.quoteName(String.valueOf(string) + "." + string2);
    }

    protected String getColumnList() {
        if (this._cols.size() == 0) {
            return "1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = 0;
        while (n < this._cols.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)this._cols.elementAt(n));
            ++n;
        }
        if (this._select != null) {
            if (n > 0) {
                stringBuffer.append(",").append(this._select);
            } else {
                stringBuffer.append(this._select);
            }
        }
        return stringBuffer.toString();
    }

    public String getStatement(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        if (this._distinct) {
            stringBuffer.append(" DISTINCT ");
        }
        if (this._select == null) {
            stringBuffer.append(this.getColumnList());
        } else {
            stringBuffer.append(this._select).append(" ");
        }
        stringBuffer.append(" FROM ");
        Hashtable hashtable = (Hashtable)this._tables.clone();
        boolean bl2 = true;
        int n = 0;
        while (n < this._joins.size()) {
            Join join = (Join)this._joins.elementAt(n);
            if (join.outer) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append("{oj ");
                stringBuffer.append(this._factory.quoteName(join.leftTable)).append(" LEFT OUTER JOIN ");
                stringBuffer.append(this._factory.quoteName(join.rightTable)).append(" ON ");
                int n2 = 0;
                while (n2 < join.leftColumns.length) {
                    if (n2 > 0) {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(this._factory.quoteName(String.valueOf(join.leftTable) + "." + join.leftColumns[n2])).append("=");
                    stringBuffer.append(this._factory.quoteName(String.valueOf(join.rightTable) + "." + join.rightColumns[n2]));
                    ++n2;
                }
                stringBuffer.append("}");
                hashtable.remove(join.leftTable);
                hashtable.remove(join.rightTable);
            }
            ++n;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this._factory.quoteName((String)enumeration.nextElement()));
        }
        bl2 = true;
        int n3 = 0;
        while (n3 < this._joins.size()) {
            Join join = (Join)this._joins.elementAt(n3);
            if (!join.outer) {
                if (bl2) {
                    stringBuffer.append(" WHERE ");
                    bl2 = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                int n4 = 0;
                while (n4 < join.leftColumns.length) {
                    if (n4 > 0) {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(this._factory.quoteName(String.valueOf(join.leftTable) + "." + join.leftColumns[n4])).append("=");
                    stringBuffer.append(this._factory.quoteName(String.valueOf(join.rightTable) + "." + join.rightColumns[n4]));
                    ++n4;
                }
            }
            ++n3;
        }
        bl2 = this.addWhereClause(stringBuffer, bl2);
        if (this._order != null) {
            stringBuffer.append(" ORDER BY ").append(this._order);
        }
        return stringBuffer.toString();
    }

    public void setDistinct(boolean bl) {
        this._distinct = bl;
    }

    public String toString() {
        return "<" + this.getStatement(false) + ">";
    }

    static class Join {
        final String leftTable;
        final String[] leftColumns;
        final String rightTable;
        final String[] rightColumns;
        final boolean outer;

        Join(String string, String string2, String string3, String string4, boolean bl) {
            this.leftTable = string;
            this.leftColumns = new String[]{string2};
            this.rightTable = string3;
            this.rightColumns = new String[]{string4};
            this.outer = bl;
        }

        Join(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
            this.leftTable = string;
            this.leftColumns = (String[])stringArray.clone();
            this.rightTable = string2;
            this.rightColumns = (String[])stringArray2.clone();
            this.outer = bl;
        }
    }
}

