/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class SequenceKeyGenerator
implements KeyGenerator {
    protected final PersistenceFactory _factory;
    protected final String _seqName;
    private final byte _style;
    private final int _sqlType;
    private int _increment;
    private boolean _triggerPresent;

    public SequenceKeyGenerator(PersistenceFactory persistenceFactory, Properties properties, int n) throws MappingException {
        String string = persistenceFactory.getFactoryName();
        boolean bl = "true".equals(properties.getProperty("returning"));
        this._triggerPresent = "true".equals(properties.getProperty("trigger", "false"));
        if (!(string.equals("oracle") || string.equals("postgresql") || string.equals("interbase") || string.equals("sapdb"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), string));
        }
        if ((string.equals("postgresql") || string.equals("interbase") || string.equals("sapdb")) && bl) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "returning=\"true\"", this.getClass().getName(), string));
        }
        this._factory = persistenceFactory;
        this._seqName = properties.getProperty("sequence", "{0}_seq");
        this._style = (byte)(string.equals("postgresql") || string.equals("interbase") ? -1 : (bl ? 0 : 1));
        if (this._triggerPresent && this._style == -1) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "trigger=\"true\"", this.getClass().getName(), string));
        }
        this._sqlType = n;
        if (n != 4 && n != 2 && n != 3 && n != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
        try {
            this._increment = Integer.parseInt(properties.getProperty("increment", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            this._increment = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection connection, String string, String string2, Properties properties) throws PersistenceException {
        BigDecimal bigDecimal;
        Statement statement;
        block13: {
            Long l;
            block12: {
                Integer n;
                block11: {
                    statement = null;
                    try {
                        try {
                            statement = connection.createStatement();
                            ResultSet resultSet = this._factory.getFactoryName().equals("interbase") ? statement.executeQuery("select gen_id(" + MessageFormat.format(this._seqName, string) + "," + this._increment + ") from rdb$database") : (this._style == -1 ? statement.executeQuery("SELECT nextval('" + MessageFormat.format(this._seqName, string) + "')") : statement.executeQuery("SELECT " + this._factory.quoteName(String.valueOf(MessageFormat.format(this._seqName, string)) + ".currval") + " FROM " + this._factory.quoteName(string)));
                            if (!resultSet.next()) throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                            int n2 = resultSet.getInt(1);
                            if (this._sqlType == 4) {
                                n = new Integer(n2);
                                Object var10_11 = null;
                                if (statement == null) return n;
                                break block11;
                            }
                            if (this._sqlType == -5) {
                                l = new Long(n2);
                                break block12;
                            }
                            bigDecimal = new BigDecimal((double)n2);
                            break block13;
                        }
                        catch (SQLException sQLException) {
                            throw new PersistenceException(Messages.format("persist.keyGenSQL", sQLException.toString()));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        if (statement == null) throw throwable;
                        try {
                            statement.close();
                            throw throwable;
                        }
                        catch (SQLException sQLException) {
                            throw throwable;
                        }
                    }
                }
                try {}
                catch (SQLException sQLException) {}
                statement.close();
                return n;
            }
            Object var10_12 = null;
            if (statement == null) return l;
            try {}
            catch (SQLException sQLException) {}
            statement.close();
            return l;
        }
        Object var10_13 = null;
        if (statement == null) return bigDecimal;
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return bigDecimal;
    }

    public byte getStyle() {
        return this._style;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public String patchSQL(String string, String string2) throws MappingException {
        if (this._style == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("INSERT")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("INTO")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.startsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        String string4 = MessageFormat.format(this._seqName, string3);
        int n = string.indexOf(40);
        int n2 = string.indexOf(40, n + 1);
        if (n < 0) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!this._triggerPresent) {
            if (n2 < 0) {
                n2 = n;
                n = string.indexOf(" VALUES ");
                stringBuffer.insert(n2 + 1, this._factory.quoteName(String.valueOf(string4) + ".nextval"));
                stringBuffer.insert(n + 1, "(" + this._factory.quoteName(string2) + ") ");
            } else {
                stringBuffer.insert(n2 + 1, String.valueOf(this._factory.quoteName(String.valueOf(string4) + ".nextval")) + ",");
                stringBuffer.insert(n + 1, String.valueOf(this._factory.quoteName(string2)) + ",");
            }
        }
        if (this._style == 0) {
            stringBuffer.append(" RETURNING ");
            stringBuffer.append(this._factory.quoteName(string2));
            stringBuffer.append(" INTO ?");
        }
        return stringBuffer.toString();
    }
}

