/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceEngineFactory;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DatabaseRegistry {
    public static final String GenericEngine = "generic";
    private String _jdbcUrl;
    private Properties _jdbcProps;
    private DataSource _dataSource;
    private MappingResolver _mapResolver;
    private String _name;
    private LockEngine _engine;
    private static Hashtable _databases = new Hashtable();
    private static Hashtable _byEngine = new Hashtable();
    private static MappingResolver _defaultMapping;
    public static String DefaultMapping;
    static /* synthetic */ Class class$org$exolab$castor$jdo$conf$Database;

    static {
        DefaultMapping = "mapping.xml";
    }

    DatabaseRegistry(String string, MappingResolver mappingResolver, PersistenceFactory persistenceFactory, String string2, Properties properties, LogInterceptor logInterceptor) throws MappingException {
        this(string, mappingResolver, persistenceFactory, logInterceptor);
        this._jdbcUrl = string2;
        this._jdbcProps = properties;
    }

    DatabaseRegistry(String string, MappingResolver mappingResolver, PersistenceFactory persistenceFactory, DataSource dataSource, LogInterceptor logInterceptor) throws MappingException {
        this(string, mappingResolver, persistenceFactory, logInterceptor);
        this._dataSource = dataSource;
    }

    DatabaseRegistry(String string, MappingResolver mappingResolver, PersistenceFactory persistenceFactory, LogInterceptor logInterceptor) throws MappingException {
        this._name = string;
        this._mapResolver = mappingResolver;
        this._engine = new PersistenceEngineFactory().createEngine(mappingResolver, persistenceFactory, logInterceptor);
        _byEngine.put(this._engine, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Connection createConnection() throws SQLException {
        if (this._dataSource != null) {
            return this._dataSource.getConnection();
        }
        return DriverManager.getConnection(this._jdbcUrl, this._jdbcProps);
    }

    static Connection createConnection(LockEngine lockEngine) throws SQLException {
        DatabaseRegistry databaseRegistry = (DatabaseRegistry)_byEngine.get(lockEngine);
        if (databaseRegistry._dataSource != null) {
            return databaseRegistry._dataSource.getConnection();
        }
        return DriverManager.getConnection(databaseRegistry._jdbcUrl, databaseRegistry._jdbcProps);
    }

    public static DatabaseRegistry getDatabaseRegistry(Object object) {
        Enumeration enumeration = _databases.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRegistry databaseRegistry = (DatabaseRegistry)enumeration.nextElement();
            if (databaseRegistry._mapResolver.getDescriptor(object.getClass()) == null) continue;
            return databaseRegistry;
        }
        return null;
    }

    public static synchronized DatabaseRegistry getDatabaseRegistry(String string) {
        DatabaseRegistry databaseRegistry = (DatabaseRegistry)_databases.get(string);
        return databaseRegistry;
    }

    static LockEngine getLockEngine(Class clazz) {
        Enumeration enumeration = _databases.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRegistry databaseRegistry = (DatabaseRegistry)enumeration.nextElement();
            if (databaseRegistry._mapResolver.getDescriptor(clazz) == null) continue;
            return databaseRegistry._engine;
        }
        return null;
    }

    static LockEngine getLockEngine(DatabaseRegistry databaseRegistry) {
        return databaseRegistry._engine;
    }

    public MappingResolver getMappingResolver() {
        return this._mapResolver;
    }

    public String getName() {
        return this._name;
    }

    public static synchronized void loadDatabase(InputSource inputSource, EntityResolver entityResolver, LogInterceptor logInterceptor, ClassLoader classLoader) throws MappingException {
        Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$jdo$conf$Database != null ? class$org$exolab$castor$jdo$conf$Database : (class$org$exolab$castor$jdo$conf$Database = DatabaseRegistry.class$("org.exolab.castor.jdo.conf.Database")));
        try {
            DatabaseRegistry databaseRegistry;
            if (entityResolver == null) {
                unmarshaller.setEntityResolver(new DTDResolver());
            } else {
                unmarshaller.setEntityResolver(new DTDResolver(entityResolver));
            }
            Database database = (Database)unmarshaller.unmarshal(inputSource);
            if (_databases.get(database.getName()) != null) {
                return;
            }
            PersistenceFactory persistenceFactory = database.getEngine() == null ? PersistenceFactoryRegistry.getPersistenceFactory(GenericEngine) : PersistenceFactoryRegistry.getPersistenceFactory(database.getEngine());
            if (persistenceFactory == null) {
                throw new MappingException("jdo.noSuchEngine", database.getEngine());
            }
            org.exolab.castor.mapping.Mapping mapping = new org.exolab.castor.mapping.Mapping(classLoader);
            if (entityResolver != null) {
                mapping.setEntityResolver(entityResolver);
            }
            if (inputSource.getSystemId() != null) {
                mapping.setBaseURL(inputSource.getSystemId());
            }
            Enumeration enumeration = database.enumerateMapping();
            while (enumeration.hasMoreElements()) {
                mapping.loadMapping(((Mapping)enumeration.nextElement()).getHref());
            }
            if (database.getDriver() != null) {
                if (database.getDriver().getClassName() != null) {
                    try {
                        Class.forName(database.getDriver().getClassName()).newInstance();
                    }
                    catch (Exception exception) {
                        throw new MappingException(exception);
                    }
                }
                if (DriverManager.getDriver(database.getDriver().getUrl()) == null) {
                    throw new MappingException("jdo.missingDriver", database.getDriver().getUrl());
                }
                Properties properties = new Properties();
                Enumeration enumeration2 = database.getDriver().enumerateParam();
                while (enumeration2.hasMoreElements()) {
                    Param param = (Param)enumeration2.nextElement();
                    ((Hashtable)properties).put(param.getName(), param.getValue());
                }
                databaseRegistry = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, persistenceFactory), persistenceFactory, database.getDriver().getUrl(), properties, logInterceptor);
            } else if (database.getDataSource() != null) {
                DataSource dataSource = database.getDataSource().getParams();
                if (dataSource == null) {
                    throw new MappingException("jdo.missingDataSource", database.getName());
                }
                databaseRegistry = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, persistenceFactory), persistenceFactory, dataSource, logInterceptor);
            } else if (database.getJndi() != null) {
                Object object;
                try {
                    object = new InitialContext().lookup(database.getJndi().getName());
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw new MappingException("jdo.jndiNameNotFound", database.getJndi().getName());
                }
                catch (NamingException namingException) {
                    throw new MappingException(namingException);
                }
                if (!(object instanceof DataSource)) {
                    throw new MappingException("jdo.jndiNameNotFound", database.getJndi().getName());
                }
                databaseRegistry = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, persistenceFactory), persistenceFactory, (DataSource)object, logInterceptor);
            } else {
                throw new MappingException("jdo.missingDataSource", database.getName());
            }
            _databases.put(database.getName(), databaseRegistry);
        }
        catch (MappingException mappingException) {
            throw mappingException;
        }
        catch (Exception exception) {
            throw new MappingException(exception);
        }
    }
}

