/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.util.Messages;

public final class QueryResults {
    private final TransactionContext _tx;
    private final LockEngine _engine;
    private final PersistenceQuery _query;
    private final AccessMode _accessMode;
    private Object _lastIdentity;
    private Database _db;

    QueryResults(TransactionContext transactionContext, LockEngine lockEngine, PersistenceQuery persistenceQuery, AccessMode accessMode, Database database) {
        this._tx = transactionContext;
        this._engine = lockEngine;
        this._query = persistenceQuery;
        this._accessMode = lockEngine.getClassMolder(this._query.getResultType()).getAccessMode(accessMode);
        this._db = database;
    }

    public void close() {
        this._query.close();
    }

    public Object fetch() throws TransactionNotInProgressException, PersistenceException, ObjectNotFoundException, LockNotGrantedException {
        if (this._tx.getStatus() != 0) {
            throw new TransactionNotInProgressException(Messages.message("persist.noTransaction"));
        }
        if (this._lastIdentity == null) {
            throw new IllegalStateException(Messages.message("jdo.fetchNoNextIdentity"));
        }
        ClassMolder classMolder = this._engine.getClassMolder(this._query.getResultType());
        Object object = this._tx.load(this._engine, classMolder, this._lastIdentity, this._accessMode);
        return object;
    }

    public Class getResultType() {
        return this._query.getResultType();
    }

    public TransactionContext getTransaction() {
        return this._tx;
    }

    public Object nextIdentity() throws TransactionNotInProgressException, PersistenceException {
        if (this._tx.getStatus() != 0) {
            throw new TransactionNotInProgressException(Messages.message("persist.noTransaction"));
        }
        try {
            this._lastIdentity = this._query.nextIdentity(this._lastIdentity);
        }
        catch (PersistenceException persistenceException) {
            this._lastIdentity = null;
            throw persistenceException;
        }
        return this._lastIdentity;
    }
}

