/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLFieldDescriptor;

public class FieldValidator
extends Validator {
    private int minOccurs = 0;
    private int maxOccurs = -1;
    private XMLFieldDescriptor _descriptor = null;
    private TypeValidator _validator = null;

    public FieldValidator() {
    }

    public FieldValidator(TypeValidator typeValidator) {
        this._validator = typeValidator;
    }

    public boolean hasTypeValidator() {
        return this._validator != null;
    }

    public void setDescriptor(XMLFieldDescriptor xMLFieldDescriptor) {
        this._descriptor = xMLFieldDescriptor;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n < 0 ? 0 : n;
    }

    public void setValidator(TypeValidator typeValidator) {
        this._validator = typeValidator;
    }

    public void validate(Object object, ClassDescriptorResolver classDescriptorResolver) throws ValidationException {
        if (this._descriptor == null) {
            return;
        }
        if (this._descriptor.isReference()) {
            return;
        }
        FieldHandler fieldHandler = this._descriptor.getHandler();
        if (fieldHandler == null) {
            return;
        }
        Object object2 = fieldHandler.getValue(object);
        if (object2 == null && this._descriptor.isRequired()) {
            String string = this._descriptor.getXMLName();
            string = String.valueOf(string) + " is a required field.";
            throw new ValidationException(string);
        }
        if (object2 != null) {
            Class<?> clazz = object2.getClass();
            int n = 1;
            boolean bl = false;
            if (clazz.isArray()) {
                boolean bl2 = bl = clazz.getComponentType() == Byte.TYPE;
                if (!bl) {
                    n = Array.getLength(object2);
                    if (this._validator != null) {
                        int n2 = 0;
                        while (n2 < n) {
                            this._validator.validate(Array.get(object2, n2));
                            ++n2;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 < n) {
                            super.validate(Array.get(object2, n3), classDescriptorResolver);
                            ++n3;
                        }
                    }
                }
            } else if (object2 instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object2;
                n = 0;
                while (enumeration.hasMoreElements()) {
                    ++n;
                    Object e = enumeration.nextElement();
                    if (this._validator != null) {
                        this._validator.validate(e);
                        continue;
                    }
                    super.validate(e, classDescriptorResolver);
                }
            } else if (object2 instanceof Vector) {
                Vector vector = (Vector)object2;
                n = vector.size();
                int n4 = 0;
                while (n4 < vector.size()) {
                    if (this._validator != null) {
                        this._validator.validate(vector.elementAt(n4));
                    } else {
                        super.validate(vector.elementAt(n4), classDescriptorResolver);
                    }
                    ++n4;
                }
            } else if (this._validator != null) {
                this._validator.validate(object2);
            } else {
                super.validate(object2, classDescriptorResolver);
            }
            if (n < this.minOccurs) {
                String string = "A minimum of " + this.minOccurs + " ";
                string = String.valueOf(string) + this._descriptor.getXMLName() + " object(s) are required.";
                throw new ValidationException(string);
            }
            if (this.maxOccurs >= 0 && n > this.maxOccurs) {
                String string = "A maximum of " + this.maxOccurs + " ";
                string = String.valueOf(string) + this._descriptor.getXMLName() + " object(s) are required.";
                throw new ValidationException(string);
            }
        }
    }
}

