/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.TypeReference;
import org.exolab.castor.xml.schema.XMLType;

public class ElementDecl
extends Particle {
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + (class$org$exolab$castor$xml$schema$ElementDecl != null ? class$org$exolab$castor$xml$schema$ElementDecl : (class$org$exolab$castor$xml$schema$ElementDecl = ElementDecl.class$("org.exolab.castor.xml.schema.ElementDecl"))).getName();
    private boolean isAbstract = false;
    private String name = null;
    String elementRef = null;
    private XMLType xmlType = null;
    private boolean hasTypeReference = false;
    private Schema schema = null;
    private boolean nullable = false;
    private String _default = null;
    private String _block;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$ElementDecl;

    public ElementDecl(Schema schema) {
        this(schema, null);
    }

    public ElementDecl(Schema schema, String string) {
        super(1, 1);
        if (schema == null) {
            String string2 = String.valueOf(NULL_ARGUMENT) + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this.schema = schema;
        this.name = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getBlock() {
        return this._block;
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (this.isReference() && !bl) {
            return this.elementRef;
        }
        return this.name;
    }

    public ElementDecl getReference() {
        if (this.elementRef != null) {
            return this.schema.getElementDecl(this.elementRef);
        }
        return null;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public short getStructureType() {
        return 7;
    }

    public XMLType getType() {
        if (this.isReference()) {
            ElementDecl elementDecl = this.getReference();
            if (elementDecl != null) {
                return elementDecl.getType();
            }
            return null;
        }
        if (this.xmlType == null) {
            return null;
        }
        return this.xmlType.getType();
    }

    public boolean hasTypeReference() {
        return this.hasTypeReference;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isReference() {
        return this.elementRef != null;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setBlock(String string) {
        this._block = string;
    }

    public void setDefaultValue(String string) {
        this._default = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public void setReference(String string) {
        this.elementRef = string;
    }

    public void setReference(ElementDecl elementDecl) {
        this.elementRef = elementDecl == null ? null : elementDecl.getName();
    }

    public void setType(XMLType xMLType) {
        this.hasTypeReference = false;
        if (xMLType != null && xMLType.isSimpleType()) {
            ((SimpleType)xMLType).setParent(this);
        }
        this.xmlType = xMLType;
    }

    public void setTypeReference(String string) {
        this.hasTypeReference = true;
        TypeReference typeReference = new TypeReference();
        typeReference.setName(string);
        typeReference.setSchema(this.schema);
        this.setType(typeReference);
    }

    public void validate() throws ValidationException {
        if (this.elementRef != null) {
            if (this.schema.getElementDecl(this.elementRef) == null) {
                String string = "<element ref=\"" + this.elementRef + "\"> " + "is not resolvable.";
                throw new ValidationException(string);
            }
        } else if (this.name == null) {
            String string = "<element> is missing required 'name' or 'ref' attribute.";
            throw new ValidationException(string);
        }
    }
}

